/**
 * Copyright (C) 2010  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.osgi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;

import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.http.HttpService;
import org.ow2.orchestra.util.Misc;


/**
 * @author Guillaume Porcher
 *
 */
public class OrchestraWSEngineActivator {

  // Default environment for deployed services
  private static final String DEFAULT_ENV_CONFIG_FILE = "conf/environment.xml";
  private static final String DEFAULT_ENV_CONFIG_RESOURCE = "environment.xml";

  protected HttpService httpService;
  protected OrchestraExtensionService orchestraExtensionService;
  protected ConfigurationAdmin configAdmin;


  private final BundleContext context;
  private Configuration engineConfig;

  public OrchestraWSEngineActivator(final BundleContext context) {
    this.context = context;
  }


  /**
   * @param httpService the httpService to set
   */
  public void setHttpService(final HttpService httpService) {
    this.httpService = httpService;
  }

  /**
   * @param orchestraExtensionService the orchestraExtensionService to set
   */
  public void setOrchestraExtensionService(final OrchestraExtensionService orchestraExtensionService) {
    this.orchestraExtensionService = orchestraExtensionService;
  }

  public void unsetOrchestraExtensionService(final OrchestraExtensionService orchestraExtensionService) {
    this.orchestraExtensionService = null;
  }

  /**
   * @param configAdmin the configAdmin to set
   */
  public void setConfigAdmin(final ConfigurationAdmin configAdmin) {
    this.configAdmin = configAdmin;
  }


  public void unsetConfigAdmin(final ConfigurationAdmin configAdmin) throws IOException {
    if (this.engineConfig != null) {
      this.engineConfig.delete();
      this.engineConfig = null;
    }
    this.configAdmin = null;
  }

  public void start() throws Exception {
    URL envUrl = null;
    final File envFile = new File(OrchestraWSEngineActivator.DEFAULT_ENV_CONFIG_FILE);
    if (envFile.exists()) {
      try {
        envUrl = envFile.toURI().toURL();
      } catch (final MalformedURLException e) {
        Misc.unreachableStatement();
      }
    }
    if (envUrl == null) {
      envUrl = this.context.getBundle().getResource(OrchestraWSEngineActivator.DEFAULT_ENV_CONFIG_RESOURCE);
    }
    Misc.log(Level.INFO, "Environment will be taken from: %s", envUrl);

    this.engineConfig =
      this.configAdmin.createFactoryConfiguration(OrchestraOSGiEngine.class.getName(), null);
    final Properties engineProperties = new Properties();
    engineProperties.setProperty("environmentLocation", envUrl.toExternalForm());

    this.engineConfig.update(engineProperties);
  }

  public void stop() throws Exception {
    this.unsetConfigAdmin(this.configAdmin);
    this.unsetOrchestraExtensionService(this.orchestraExtensionService);
  }

}
