/**
 * Copyright (C) 2010  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.osgi.impl;

import java.util.HashMap;
import java.util.Map;

import org.ow2.orchestra.osgi.OrchestraExtensionService;


/**
 * @author Guillaume Porcher
 *
 */
public class OrchestraExtensionServiceImpl implements OrchestraExtensionService {

  private final Map<String, Class< ? >> extensions = new HashMap<String, Class< ? >>();

  public void addExtension(final Class< ? > extensionClass) {
    this.extensions.put(extensionClass.getName(), extensionClass);
  }

  public void removeExtension(final Class< ? > extensionClass) {
    this.extensions.remove(extensionClass.getName());
  }

  public Class< ? > getExtension(final String className) {
    return this.extensions.get(className);
  }

  public ClassLoader getClassLoader() {
    return new OrchestraExtensionClassLoader(this.extensions);
  }

  private static class OrchestraExtensionClassLoader extends ClassLoader {

    private final Map<String, Class< ? >> extensions;

    public OrchestraExtensionClassLoader(final Map<String, Class< ? >> extensions) {
      super(OrchestraExtensionClassLoader.class.getClassLoader());
      this.extensions = extensions;
    }

    @Override
    protected Class< ? > findClass(final String name) throws ClassNotFoundException {
      return this.extensions.get(name);
    }
  }
}
