/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.orchestra.env.EnvFactoryRepository;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployer;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.util.Misc;

public class JMXAgent {
    private MBeanServer mbs;
    private ObjectName objectName;
    private JMXConnectorServer cs;

    public void startOrchestra(EnvironmentFactory envFactory) {
        EnvFactoryRepository.set(envFactory);
        RemoteDeployer remoteDeployer = new RemoteDeployer();
        remoteDeployer.initialize();
        JobExecutor jobExecutor = envFactory.get(JobExecutor.class);
        if (jobExecutor != null) {
            jobExecutor.start();
        }
        Properties orchestraProperties = (Properties)envFactory.get("orchestra-properties");
        try {
            int jmxPort = Integer.parseInt(orchestraProperties.getProperty("orchestra.jmx.port"));
            LocateRegistry.createRegistry(jmxPort);
            this.mbs = ManagementFactory.getPlatformMBeanServer();
            this.objectName = ObjectName.getInstance(orchestraProperties.getProperty("orchestra.jmx.objectName"));
            this.mbs.registerMBean(remoteDeployer, this.objectName);
            JMXServiceURL url = new JMXServiceURL(orchestraProperties.getProperty("orchestra.jmx.serviceUrl"));
            this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mbs);
            this.cs.start();
            Misc.log(Level.INFO, "Orchestra is started using JMX connector [" + url.toString() + "]", new Object[0]);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Problem registering mbean in mbean server", e);
        }
    }

    public void stopOrchestra() {
        if (this.mbs != null) {
            try {
                this.cs.stop();
                this.mbs.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("Problem unregistering mbean", e);
            }
        }
        if (EnvFactoryRepository.get() != null) {
            JobExecutor jobExecutor = EnvFactoryRepository.get().get(JobExecutor.class);
            if (jobExecutor != null) {
                jobExecutor.stop(true);
            }
            EnvFactoryRepository.get().close();
            EnvFactoryRepository.set(null);
        }
    }
}

