/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db;

import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.ProcessFullDefinitionImpl;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.full.impl.ProcessFullInstanceImpl;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.persistence.QuerierDbSession;
import org.ow2.orchestra.persistence.db.AbstractDbQuerier;
import org.ow2.orchestra.services.Archivable;
import org.ow2.orchestra.services.Archiver;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

public class DbHistory
extends AbstractDbQuerier
implements Archiver {
    public DbHistory(QuerierDbSession dbSession) {
        super(dbSession);
    }

    public void archive(ProcessFullInstance processFullInstance) {
        Misc.checkArgsNotNull(processFullInstance);
        if (this.getProcessInstance(processFullInstance.getUUID()) != null) {
            throw new IllegalArgumentException(" Can't archive: " + processFullInstance + " --- A record with processInstanceUUID: " + processFullInstance.getUUID() + " has already been archived ");
        }
        this.getQuerierDbSession().save(new ProcessFullInstanceImpl(processFullInstance));
    }

    public void remove(ProcessFullInstance processFullInstance) {
        Misc.checkArgsNotNull(processFullInstance);
        if (EnvTool.getHistoryQueriers().getProcessInstance(processFullInstance.getUUID()) != null) {
            this.getQuerierDbSession().delete(new ProcessFullInstanceImpl(processFullInstance));
        }
    }

    public void archive(ProcessFullDefinition processFullDefinition) {
        Misc.checkArgsNotNull(processFullDefinition);
        if (this.getProcessDefinition((ProcessDefinitionUUID)processFullDefinition.getUUID()) != null) {
            throw new IllegalArgumentException(" Can't archive: " + processFullDefinition + " --- A record with procesDefinitionUUID: " + processFullDefinition.getUUID() + " has already been archived ");
        }
        this.getQuerierDbSession().save(new ProcessFullDefinitionImpl(processFullDefinition));
    }

    public void remove(ProcessFullDefinition processFullDefinition) {
        Misc.checkArgsNotNull(processFullDefinition);
        if (EnvTool.getHistoryQueriers().getProcessDefinition((ProcessDefinitionUUID)processFullDefinition.getUUID()) != null) {
            this.getQuerierDbSession().delete(new ProcessFullDefinitionImpl(processFullDefinition));
        }
    }

    public void archive(Archivable archivable) {
        if (archivable instanceof ProcessFullDefinition) {
            this.archive((ProcessFullDefinition)archivable);
        } else if (archivable instanceof ProcessFullInstance) {
            this.archive((ProcessFullInstance)archivable);
        } else {
            Misc.unreachableStatement();
        }
    }

    public void remove(Archivable archivable) {
        if (archivable instanceof ProcessFullDefinition) {
            this.remove((ProcessFullDefinition)archivable);
        } else if (archivable instanceof ProcessFullInstance) {
            this.remove((ProcessFullInstance)archivable);
        } else {
            Misc.unreachableStatement();
        }
    }
}

