/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.operation;

import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.tx.StandardResource;
import org.ow2.orchestra.pvm.internal.tx.StandardTransaction;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireException;
import org.ow2.orchestra.pvm.internal.wire.operation.Operation;

public class EnlistOperation
implements Operation {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog(EnlistOperation.class.getName());
    private String transactionName = null;

    public void apply(Object target, WireContext wireContext) {
        if (!(target instanceof StandardResource)) {
            throw new WireException("operation enlist can only be applied on objects that implement " + StandardResource.class.getName() + ": " + target + (target != null ? " (" + target.getClass().getName() + ")" : ""));
        }
        Object object = null;
        object = this.transactionName != null ? wireContext.get(this.transactionName) : wireContext.get(Transaction.class);
        if (object == null || !(object instanceof StandardTransaction)) {
            throw new WireException("couldn't find " + StandardTransaction.class.getName() + " " + (this.transactionName != null ? "'" + this.transactionName + "'" : "by type") + " to enlist resource " + target);
        }
        StandardTransaction standardTransaction = (StandardTransaction)object;
        log.trace("enlisting resource " + target + " with transaction");
        standardTransaction.enlistResource((StandardResource)target);
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }
}

