/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.ReplierKey;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageCarrierRepository {
    private static Map<ReplierKey, MessageCarrier> messageCarriers = new HashMap<ReplierKey, MessageCarrier>();
    private static Map<String, MessageCarrier> pendingMessageCarriers = new HashMap<String, MessageCarrier>();
    private static Map<Transaction, TransactionnalMap<ReplierKey, MessageCarrier>> msgCarriersCopies = new HashMap<Transaction, TransactionnalMap<ReplierKey, MessageCarrier>>();
    private static Map<Transaction, TransactionnalMap<String, MessageCarrier>> pendingMsgCarriersCopies = new HashMap<Transaction, TransactionnalMap<String, MessageCarrier>>();

    private MessageCarrierRepository() {
    }

    private static synchronized Map<String, MessageCarrier> getPendingMessageCarriers() {
        final Transaction transaction = Environment.getCurrent().get(Transaction.class);
        if (transaction != null) {
            TransactionnalMap<String, MessageCarrier> pendingMsgCarriers = pendingMsgCarriersCopies.get(transaction);
            if (pendingMsgCarriers == null) {
                pendingMsgCarriers = new TransactionnalMap<String, MessageCarrier>(transaction, pendingMessageCarriers);
                pendingMsgCarriersCopies.put(transaction, pendingMsgCarriers);
                Synchronization synchro = new Synchronization(){

                    public void afterCompletion(int status) {
                        TransactionnalMap tm = (TransactionnalMap)pendingMsgCarriersCopies.remove(transaction);
                        if (status == 3) {
                            tm.synchronize();
                        }
                    }

                    public void beforeCompletion() {
                    }
                };
                transaction.registerSynchronization(synchro);
            }
            return pendingMsgCarriers;
        }
        return pendingMessageCarriers;
    }

    static synchronized Map<ReplierKey, MessageCarrier> getMessageCarriers() {
        final Transaction transaction = Environment.getCurrent().get(Transaction.class);
        if (transaction != null) {
            TransactionnalMap<ReplierKey, MessageCarrier> msgCarriers = msgCarriersCopies.get(transaction);
            if (msgCarriers == null) {
                msgCarriers = new TransactionnalMap<ReplierKey, MessageCarrier>(transaction, messageCarriers);
                msgCarriersCopies.put(transaction, msgCarriers);
                Synchronization synchro = new Synchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int status) {
                        TransactionnalMap tm = (TransactionnalMap)msgCarriersCopies.remove(transaction);
                        if (status == 3) {
                            tm.synchronize();
                        }
                    }
                };
                transaction.registerSynchronization(synchro);
            }
            return msgCarriers;
        }
        return messageCarriers;
    }

    public static synchronized void addMessageCarrier(ReplierKey replierKey, MessageCarrier messageCarrier) {
        MessageCarrierRepository.getMessageCarriers().put(replierKey, messageCarrier);
    }

    public static synchronized void associateMessage(ReplierKey replierKey, MessageVariable message) {
        MessageCarrier messageCarrier = MessageCarrierRepository.getMessageCarriers().get(replierKey);
        if (messageCarrier == null) {
            throw new OrchestraRuntimeException("No MessageCarrier corresponding to key = " + replierKey);
        }
        MessageCarrierRepository.removeMessageCarrier(replierKey);
        messageCarrier.setMessage(message);
    }

    public static void associateFaultMessage(ReplierKey replierKey, QName faultQName, MessageVariable message) {
        MessageCarrier messageCarrier = MessageCarrierRepository.getMessageCarriers().get(replierKey);
        if (messageCarrier == null) {
            throw new OrchestraRuntimeException("No MessageCarrier corresponding to key = " + replierKey);
        }
        MessageCarrierRepository.removeMessageCarrier(replierKey);
        messageCarrier.setFaultMessage(faultQName, message);
    }

    public static void throwMissingReply(ReplierKey replierKey) {
        MessageCarrier messageCarrier = MessageCarrierRepository.getMessageCarriers().get(replierKey);
        if (messageCarrier == null) {
            throw new OrchestraRuntimeException("No MessageCarrier corresponding to key = " + replierKey);
        }
        MessageCarrierRepository.removeMessageCarrier(replierKey);
        messageCarrier.throwMissingReply();
    }

    public static synchronized MessageCarrier removeMessageCarrier(ReplierKey replierKey) {
        return MessageCarrierRepository.getMessageCarriers().remove(replierKey);
    }

    public static synchronized void addPendingMessageCarrier(MessageCarrier messageCarrier) {
        MessageCarrierRepository.getPendingMessageCarriers().put(messageCarrier.getUuid(), messageCarrier);
    }

    public static synchronized MessageCarrier removePendingMessageCarrier(String messageCarrierId) {
        return MessageCarrierRepository.getPendingMessageCarriers().remove(messageCarrierId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransactionnalMap<K, V>
    implements Map<K, V> {
        private final Map<K, V> mapToCopy;
        private Map<K, V> map = new HashMap();
        private final List<K> addedEntries = new ArrayList<K>();
        private final List<K> removedEntries = new ArrayList<K>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransactionnalMap(Transaction tx, Map<K, V> mapToCopy) {
            Map<K, V> map = mapToCopy;
            synchronized (map) {
                this.map = new HashMap<K, V>(mapToCopy);
            }
            this.mapToCopy = mapToCopy;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.unmodifiableSet(this.map.entrySet());
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return Collections.unmodifiableSet(this.map.keySet());
        }

        @Override
        public V put(K key, V value) {
            this.addedEntries.add(key);
            return this.map.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            for (Map.Entry<K, V> e : t.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        public V remove(Object key) {
            if (this.map.containsKey(key)) {
                this.removedEntries.add(key);
            }
            return this.map.remove(key);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Collection<V> values() {
            return Collections.unmodifiableCollection(this.map.values());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void synchronize() {
            Map<K, V> map = this.mapToCopy;
            synchronized (map) {
                for (K key : this.addedEntries) {
                    this.mapToCopy.put(key, this.get(key));
                }
                for (K key : this.removedEntries) {
                    this.mapToCopy.remove(key);
                }
            }
        }
    }
}

