/**
 * Copyright (C) 2009  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.axis;


/**
 * @author Guillaume Porcher
 *
 */
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.felix.framework.Felix;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Constants;
import org.ow2.orchestra.osgi.OrchestraOSGiEngine;

public final class StartupListener implements ServletContextListener {

  private Felix felix;

  public void contextInitialized(final ServletContextEvent event) {
    try {
      final Map<String, Object> config = new HashMap<String, Object>();
      config.put(Constants.FRAMEWORK_SYSTEMPACKAGES_EXTRA,
          "javax.servlet;javax.servlet.http;version=2.5, "
          + "org.postgresql, "
          + "com.mysql.jdbc, "
          + "org.h2, "
          + "org.apache.derby.jdbc, "
          + "oracle.jdbc, "
          + "com.sun.org.apache.xerces.internal.dom, "
          + "com.sun.org.apache.xerces.internal.jaxp, "
          + "com.sun.org.apache.xalan.internal.xsltc.dom, "
          + "com.sun.org.apache.xml.internal.dtm, "
          + "com.sun.org.apache.xalan.internal.xsltc.trax");
      // Bundle activator launched with felix => register all war bundles
      final URL url = event.getServletContext().getResource("/WEB-INF/web.xml");
      final URL libURL = new URL(url, "lib");
      config.put("felix.auto.deploy.dir", libURL.toExternalForm());
      config.put("felix.auto.deploy.action","install, update, start");

      config.put("felix.log.level","1");

      config.put("felix.cache.rootdir", System.getProperty("java.io.tmpdir"));

      config.put("org.osgi.framework.storage.clean", "onFisrtInit");

      // add property to tell orchstra we are running from a war
      config.put(OrchestraOSGiEngine.ORCHESTRA_WAR_CONTEXT_PROP, "true");

      this.felix = new Felix(config);
      this.felix.init();
      // Use the system bundle context to process the auto-deploy
      // and auto-install/auto-start properties.
      this.installBundles(this.felix.getBundleContext(), event.getServletContext());
      // Start the framework.
      this.felix.start();
      event.getServletContext().setAttribute(BundleContext.class.getName(), this.felix.getBundleContext());
      event.getServletContext().log("OSGi framework started", null);
    } catch (final Exception e) {
      event.getServletContext().log("Error starting framework", e);
    }
  }

  public void contextDestroyed(final ServletContextEvent event) {
    try {
      if (this.felix != null) {
        this.felix.stop();
      }
    } catch (final Exception e) {
      event.getServletContext().log("Error stopping framework", e);
    }
  }

  public void installBundles(final BundleContext context, final ServletContext servletContext) throws Exception {

    final ArrayList<Bundle> installed = new ArrayList<Bundle>();
    for (final URL url : this.findBundles(servletContext)) {
      servletContext.log("Installing bundle [" + url + "]");
      final Bundle bundle = context.installBundle(url.toExternalForm());
      installed.add(bundle);
    }


    for (final Bundle bundle : installed) {
      if (bundle.getHeaders().get(Constants.FRAGMENT_HOST) == null) {
        bundle.start();
      }
    }
  }


  private List<URL> findBundles(final ServletContext servletContext) throws Exception {
    final ArrayList<URL> list = new ArrayList<URL>();
    for (final Object o : servletContext.getResourcePaths("/WEB-INF/lib/")) {
      final String name = (String) o;
      if (name.endsWith(".jar") && -1 == name.lastIndexOf("org.apache.felix.framework")) {
        final URL url = servletContext.getResource(name);
        if (url != null) {
          list.add(url);
        }
      }
    }

    return list;
  }
}
