/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StartupListener
implements ServletContextListener {
    private static final Logger LOG = Logger.getLogger(StartupListener.class.getName());
    private Felix felix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        try {
            InputStream inStream = StartupListener.class.getClassLoader().getResourceAsStream("conf/config.properties");
            Properties props = new Properties();
            try {
                props.load(inStream);
            }
            finally {
                inStream.close();
            }
            for (Object key : props.keySet()) {
                String property = (String)key;
                props.setProperty(property, Util.substVars((String)props.getProperty(property), (String)property, null, (Properties)props));
            }
            if (!props.containsKey("felix.cache.rootdir")) {
                props.put("felix.cache.rootdir", System.getProperty("java.io.tmpdir"));
            }
            props.put("orchestra.war.context", event.getServletContext().getContextPath());
            this.felix = new Felix((Map)props);
            this.felix.init();
            this.felix.start();
            this.installBundles(this.felix.getBundleContext(), event.getServletContext());
            event.getServletContext().setAttribute(BundleContext.class.getName(), (Object)this.felix.getBundleContext());
            LOG.info("OSGi framework started");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error starting framework", e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            if (this.felix != null) {
                this.felix.stop();
                FrameworkEvent fe = this.felix.waitForStop(60000L);
                if (64 == fe.getType()) {
                    LOG.info("Framework stopped.");
                } else if (fe.getThrowable() != null) {
                    LOG.log(Level.SEVERE, "Error stopping framework", fe.getThrowable());
                } else {
                    LOG.warning("Framework stopped in state " + fe.getType() + ".");
                }
                this.felix = null;
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error stopping framework", e);
        }
    }

    public void installBundles(BundleContext context, ServletContext servletContext) throws Exception {
        ArrayList<Bundle> installed = new ArrayList<Bundle>();
        for (URL url : this.findBundles(servletContext)) {
            LOG.log(Level.FINE, "Installing bundle [" + url + "]");
            Bundle bundle = context.installBundle(url.toExternalForm(), url.openStream());
            installed.add(bundle);
        }
        for (Bundle bundle : installed) {
            if (bundle.getHeaders().get("Fragment-Host") != null) continue;
            bundle.start();
        }
    }

    private List<URL> findBundles(ServletContext servletContext) throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        for (Object o : servletContext.getResourcePaths("/WEB-INF/bundle/")) {
            URL url;
            String name = (String)o;
            if (!name.endsWith(".jar") || (url = servletContext.getResource(name)) == null) continue;
            list.add(url);
        }
        return list;
    }
}

