/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.foreach;

import java.util.Arrays;
import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class NestedForEachTest
extends BpelTestCase {
    public NestedForEachTest() {
        super("http://orchestra.ow2.org/foreach", "nestedForeach");
    }

    public void testNestedForEach() {
        this.deploy();
        this.launch(1, 4);
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch(final int start, final int stop) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        QName portTypeQName = new QName(this.getProcessNamespace(), "foreachPT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){
            private static final long serialVersionUID = 1624305940767648609L;

            public Object execute(Environment environment) throws Exception {
                MessageVariable reply = callResult.getMessageCarrier().getMessage();
                Object[] counts = reply.getPartValue("count").getTextContent().split(",");
                Assert.assertTrue((boolean)counts[0].equals("s"));
                int expectedSize = stop - start + 1;
                if (expectedSize < 0) {
                    expectedSize = 0;
                }
                expectedSize = expectedSize * 5 + 1;
                Arrays.deepToString(counts);
                Assert.assertEquals((int)expectedSize, (int)counts.length);
                block7: for (int i = 1; i < expectedSize; ++i) {
                    switch (i % 5) {
                        case 0: {
                            Assert.assertEquals((int)(start + i / 5 - 1), (int)Integer.parseInt((String)counts[i]));
                            continue block7;
                        }
                        case 1: {
                            Assert.assertEquals((int)5, (int)Integer.parseInt((String)counts[i]));
                            continue block7;
                        }
                        case 2: {
                            Assert.assertEquals((int)6, (int)Integer.parseInt((String)counts[i]));
                            continue block7;
                        }
                        case 3: {
                            Assert.assertEquals((int)7, (int)Integer.parseInt((String)counts[i]));
                            continue block7;
                        }
                        case 4: {
                            Assert.assertEquals((int)8, (int)Integer.parseInt((String)counts[i]));
                            continue block7;
                        }
                    }
                }
                NestedForEachTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }
}

