/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.perf.flow;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.perf.AbstractPerfTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class FlowTest
extends AbstractPerfTestCase {
    public FlowTest() {
        super("http://example.com/flow", "flow");
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("in", BpelXmlUtil.createElementWithContent((String)"Dupont"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        long endTime = callResult.getEndTime();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                MessageVariable reply = callResult.getMessageCarrier().getMessage();
                if (reply == null) {
                    throw new OrchestraRuntimeException("reply is null");
                }
                Element element = reply.getPartValue("out");
                if (element == null) {
                    throw new OrchestraRuntimeException("reply.out is null");
                }
                String result = element.getTextContent();
                if (result == null) {
                    throw new OrchestraRuntimeException("reply.out.textContent is null");
                }
                String expected = "flowResultABCDE_AE_BF";
                if (!result.equals(expected)) {
                    throw new OrchestraRuntimeException("reply.out.textContent is not " + expected + ", it is : " + result);
                }
                FlowTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    public void testFlow() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public String getAlias() {
        return "class.flow";
    }
}

