/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.deployment.Deployer;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.RuntimeDbSession;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.PartnerLinkRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.services.Archivable;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingService;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.services.itf.TestValidator;
import org.ow2.orchestra.test.EnvironmentTestCase;
import org.ow2.orchestra.test.TestInvoker;
import org.ow2.orchestra.test.TestValidatorImpl;
import org.ow2.orchestra.util.DeploymentUtil;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BpelTestCase
extends EnvironmentTestCase {
    private static Logger log = Logger.getLogger(BpelTestCase.class.getName());
    private final QName processQName;

    protected BpelTestCase(String processNamespace, String processName) {
        this.processQName = new QName(processNamespace, processName);
    }

    public static DefaultEnvXMLGenerator getBpelTestEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = new DefaultEnvXMLGenerator();
        envGenerator.setInvokerType(TestInvoker.class);
        envGenerator.setApplicationEntry("testValidator", TestValidatorImpl.class);
        return envGenerator;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        JobExecutor jobExecutor = (JobExecutor)this.getEnvironmentFactory().get(JobExecutor.class);
        if (jobExecutor != null) {
            jobExecutor.start();
        }
    }

    @Override
    public void tearDown() throws Exception {
        JobExecutor jobExecutor = (JobExecutor)this.getEnvironmentFactory().get(JobExecutor.class);
        if (jobExecutor != null) {
            jobExecutor.stop(true);
        }
        super.tearDown();
    }

    protected void deleteInstance(CallResult callResult) {
        ProcessFullInstance processFullInstance;
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        BpelExecution instance = callResult.getInstance();
        if (instance != null) {
            ((Repository)Environment.getCurrent().get(Repository.class)).removeInstance(instance);
        }
        if ((processFullInstance = EnvTool.getQuerier().getProcessInstance(callResult.getProcessInstanceUUID())) != null) {
            EnvTool.getRecorder().remove((Archivable)processFullInstance);
            EnvTool.getArchiver().remove((Archivable)processFullInstance);
        }
    }

    protected void deleteInstances(final int nb) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                List execs = ((Repository)environment.get(Repository.class)).getInstances(BpelTestCase.this.getProcessQName());
                Assert.assertEquals((int)nb, (int)execs.size());
                for (int i = 0; i < nb; ++i) {
                    BpelExecution exec = (BpelExecution)execs.get(i);
                    ((Repository)environment.get(Repository.class)).removeInstance(exec, true);
                    ProcessFullInstance processFullInstance = EnvTool.getQuerier().getProcessInstance(exec.getProcessInstanceUUID());
                    if (processFullInstance == null) continue;
                    EnvTool.getRecorder().remove((Archivable)processFullInstance);
                    EnvTool.getArchiver().remove((Archivable)processFullInstance);
                }
                return null;
            }
        });
    }

    protected void deploy(final URL bpel, final URL wsdl) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Deployer deployer = new Deployer();
                BpelTestCase.this.assertExists("Bpel file : " + bpel + " doesn't exist", bpel);
                ArrayList<URL> wsdls = null;
                if (wsdl != null) {
                    wsdls = new ArrayList<URL>();
                    wsdls.add(wsdl);
                }
                Deployment bpelDeployment = DeploymentUtil.generateDeployment((URL)bpel, wsdls);
                ProcessFullDefinition bpelProcess = deployer.deploy(bpelDeployment, environment);
                Assert.assertNotNull((Object)bpelProcess);
                return null;
            }
        });
    }

    public void undeploy() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Deployer deployer = new Deployer();
                deployer.undeploy(BpelTestCase.this.processQName, environment);
                return null;
            }
        });
    }

    public void waitForInstanceEnd(final ProcessInstanceUUID processInstanceUUID) {
        if (processInstanceUUID == null) {
            Assert.fail((String)"ProcessInstanceUUID is null");
        }
        long pollInterval = 100L;
        long timeout = 180000L;
        long startTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        while (startTime + 180000L + 100L > System.currentTimeMillis()) {
            boolean finished = (Boolean)commandService.execute((Command)new Command<Boolean>(){

                public Boolean execute(Environment environment) throws Exception {
                    ProcessFullInstance processInstance = EnvTool.getQuerier().getProcessInstance(processInstanceUUID);
                    return processInstance != null && (ActivityState.FINISHED.equals((Object)processInstance.getState()) || ActivityState.EXITED.equals((Object)processInstance.getState()));
                }
            });
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!finished) continue;
            return;
        }
        Assert.fail((String)"Instance not finished when timeout occured.");
    }

    public <E extends Exception> E waitForExceptionInInstance(ProcessInstanceUUID processInstanceUUID, Class<E> exceptionClass) {
        return this.waitForExceptionInInstance(processInstanceUUID, exceptionClass, null);
    }

    public BpelFaultException waitForExceptionInInstance(ProcessInstanceUUID processInstanceUUID, BpelFaultException.BpelFault fault) {
        return this.waitForExceptionInInstance(processInstanceUUID, BpelFaultException.class, fault.getQName());
    }

    public <E extends Exception> E waitForExceptionInInstance(final ProcessInstanceUUID processInstanceUUID, Class<E> exceptionClass, QName faultName) {
        long pollInterval = 100L;
        long timeout = 180000L;
        long startTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        while (startTime + 180000L > System.currentTimeMillis()) {
            Exception exception = (Exception)commandService.execute((Command)new Command<Exception>(){

                public Exception execute(Environment environment) throws Exception {
                    Set activityInstances = EnvTool.getQuerier().findActivityInstances(processInstanceUUID);
                    for (ActivityFullInstance activityInstance : activityInstances) {
                        if (activityInstance.getLastException() == null) continue;
                        return activityInstance.getLastException().copy();
                    }
                    return null;
                }
            });
            if (exception != null) {
                Assert.assertTrue((String)("Expected " + exceptionClass + ", found " + exception.getClass()), (boolean)exceptionClass.isInstance(exception));
                if (faultName != null) {
                    Assert.assertTrue((boolean)(exception instanceof BpelFaultException));
                    Assert.assertEquals((Object)faultName, (Object)((BpelFaultException)exception).getFaultName());
                }
                return (E)exception;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.fail((String)"Exception not detected when timeout occured.");
        return null;
    }

    public CallResult call(Map<String, Element> parts, final QName portTypeQName, final String operationName) {
        HashMap<String, Document> docParts = new HashMap<String, Document>();
        if (parts != null) {
            for (Map.Entry<String, Element> part : parts.entrySet()) {
                docParts.put(part.getKey(), part.getValue().getOwnerDocument());
            }
        }
        MessageVariable message = new MessageVariable(docParts);
        OperationKey operationKey = new OperationKey(this.processQName, portTypeQName, operationName);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        final MessageCarrier messageCarrier = (MessageCarrier)commandService.execute((Command)new Command<MessageCarrier>(){

            public MessageCarrier execute(Environment environment) throws Exception {
                BpelProcess bpelProcess = ((Repository)environment.get(Repository.class)).getProcess(BpelTestCase.this.processQName);
                boolean requestResponse = BpelTestCase.this.isRequestResponse(bpelProcess, portTypeQName, operationName);
                if (requestResponse) {
                    return new MessageCarrier();
                }
                return null;
            }
        });
        final BpelExecution bpelExecution = ReceivingService.handle((MessageVariable)message, (OperationKey)operationKey, (MessageCarrier)messageCarrier);
        return (CallResult)commandService.execute((Command)new Command<CallResult>(){

            public CallResult execute(Environment environment) throws Exception {
                ProcessInstanceUUID instance = null;
                if (bpelExecution != null) {
                    instance = bpelExecution.getProcessInstanceUUID();
                }
                long endTime = System.currentTimeMillis();
                CallResult callResult = new CallResult(instance, messageCarrier, endTime);
                return callResult;
            }
        });
    }

    protected Object getVariableValue(CallResult result, String variableName) {
        RuntimeDbSession persistenceService = (RuntimeDbSession)Environment.getCurrent().get(RuntimeDbSession.class);
        for (VariableRuntime variableRuntime : result.getVariables()) {
            if (persistenceService != null) {
                variableRuntime = (VariableRuntime)persistenceService.get(VariableRuntime.class, (Object)variableRuntime.getDbid());
            }
            if (!variableRuntime.getName().equals(variableName)) continue;
            return variableRuntime.getValue();
        }
        return null;
    }

    protected PartnerLinkRuntime getPartnerLink(CallResult result, String partnerLinkName) {
        RuntimeDbSession persistenceService = (RuntimeDbSession)Environment.getCurrent().get(RuntimeDbSession.class);
        for (PartnerLinkRuntime partnerLinkRuntime : result.getPartnerLInks()) {
            if (persistenceService != null) {
                partnerLinkRuntime = (PartnerLinkRuntime)persistenceService.get(PartnerLinkRuntime.class, (Object)partnerLinkRuntime.getDbid());
            }
            if (!partnerLinkRuntime.getName().equals(partnerLinkName)) continue;
            return partnerLinkRuntime;
        }
        return null;
    }

    protected List<String> getEvents(CallResult result) {
        return result.getEvents();
    }

    protected boolean isRequestResponse(BpelProcess bpelProcess, QName portTypeQName, String operationName) {
        PortType pt = bpelProcess.getWsdlInfos().getPortType(portTypeQName);
        if (pt == null) {
            throw new OrchestraRuntimeException("Process '" + bpelProcess.getName() + "', portType '" + portTypeQName + "' not found : cannot define if it is a request/response call or a oneWay call.");
        }
        List operations = pt.getOperations();
        for (Operation op : operations) {
            if (!op.getName().equals(operationName)) continue;
            return op.getOutput() != null;
        }
        throw new OrchestraRuntimeException("Operation '" + operationName + "' not found in portType '" + portTypeQName + "' : cannot define if it is a request/response call or a oneWay call.");
    }

    protected Element assertTopElementNS(Object o, String rootElementLocalName) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((String)"o is not an Element", (boolean)(o instanceof Element));
        Element root = (Element)o;
        Assert.assertEquals((String)rootElementLocalName, (String)root.getLocalName());
        Assert.assertEquals((String)this.processQName.getNamespaceURI(), (String)root.getNamespaceURI());
        return root;
    }

    protected Element assertElementNSContentAndNoChild(Element el, String tagName, String textContent) {
        List children = XmlUtil.elements((Element)el, (String)this.processQName.getNamespaceURI(), (String)tagName);
        Assert.assertEquals((int)1, (int)children.size());
        Element child = (Element)children.get(0);
        Assert.assertEquals((String)textContent, (String)child.getTextContent());
        this.assertNoElementChild(child);
        return child;
    }

    protected void assertNoElementChild(Element el) {
        if (el.getChildNodes().getLength() == 1) {
            Assert.assertTrue((boolean)(el.getChildNodes().item(0) instanceof Text));
        } else if (el.getChildNodes().getLength() == 2) {
            Assert.assertTrue((boolean)false);
        }
    }

    protected Element assertString(Object o, String expected) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((String)"o is not an Element", (boolean)(o instanceof Element));
        Element root = (Element)o;
        Assert.assertEquals((String)expected, (String)root.getTextContent());
        return root;
    }

    protected void assertServiceRefElement(Object o, String expectedAddress, QName expectedService) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((String)"o is not an Element", (boolean)(o instanceof Element));
        Element serviceRef = (Element)o;
        Assert.assertEquals((String)"http://docs.oasis-open.org/wsbpel/2.0/serviceref", (String)serviceRef.getNamespaceURI());
        Assert.assertEquals((String)"service-ref", (String)serviceRef.getLocalName());
        this.assertEndpointReference(serviceRef, expectedAddress, expectedService);
    }

    protected void assertServiceRefType(Object o, String expectedAddress, QName expectedService) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((String)"o is not an Element", (boolean)(o instanceof Element));
        Element defaultElement = (Element)o;
        this.assertEndpointReference(defaultElement, expectedAddress, expectedService);
    }

    protected void assertEndpointReference(Element serviceRef, String expectedAddress, QName expectedService) {
        List serviceRefChildren = XmlUtil.elements((Element)serviceRef, (String)"http://schemas.xmlsoap.org/ws/2004/08/addressing", (String)"EndpointReference");
        Assert.assertEquals((int)1, (int)serviceRefChildren.size());
        Element endpointReference = (Element)serviceRefChildren.get(0);
        List addressChildren = XmlUtil.elements((Element)endpointReference, (String)"http://schemas.xmlsoap.org/ws/2004/08/addressing", (String)"Address");
        Assert.assertEquals((int)1, (int)addressChildren.size());
        Element address = (Element)addressChildren.get(0);
        Assert.assertEquals((String)expectedAddress, (String)address.getTextContent().trim());
        this.assertNoElementChild(address);
        List serviceNameChildren = XmlUtil.elements((Element)endpointReference, (String)"http://schemas.xmlsoap.org/ws/2004/08/addressing", (String)"ServiceName");
        Assert.assertEquals((int)1, (int)serviceNameChildren.size());
        Element serviceName = (Element)serviceNameChildren.get(0);
        String serviceNameContent = serviceName.getTextContent().trim();
        String[] tab = serviceNameContent.split(":");
        QName foundService = new QName(serviceName.lookupNamespaceURI(tab[0]), tab[1]);
        Assert.assertEquals((Object)expectedService, (Object)foundService);
        this.assertNoElementChild(serviceName);
    }

    protected void assertExists(URL url) {
        this.assertExists("Error: " + url + " does not exist", url);
    }

    protected void assertExists(String failMsg, URL url) {
        try {
            url.openStream();
        }
        catch (Exception e) {
            Assert.fail((String)failMsg);
        }
    }

    public String getProcessNamespace() {
        return this.processQName.getNamespaceURI();
    }

    public String getProcessName() {
        return this.processQName.getLocalPart();
    }

    public QName getProcessQName() {
        return this.processQName;
    }

    public static List<Text> getTexts(Node n) {
        NodeList nodeList = n.getChildNodes();
        ArrayList<Text> texts = new ArrayList<Text>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Text)) continue;
            texts.add((Text)nodeList.item(i));
        }
        return texts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CallResult {
        protected ProcessInstanceUUID processInstanceUUID;
        protected MessageCarrier messageCarrier;
        protected long endTime;

        public CallResult(ProcessInstanceUUID instanceUUID, MessageCarrier messageCarrier, long endTime) {
            this.messageCarrier = messageCarrier;
            this.endTime = endTime;
            this.processInstanceUUID = instanceUUID;
        }

        public MessageCarrier getMessageCarrier() {
            return this.messageCarrier;
        }

        public List<VariableRuntime> getVariables() {
            CommandService commandService = (CommandService)BpelTestCase.this.getEnvironmentFactory().get(CommandService.class);
            return (List)commandService.execute((Command)new Command<List<VariableRuntime>>(){

                public List<VariableRuntime> execute(Environment environment) throws Exception {
                    TestValidator testValidator = (TestValidator)environment.get("testValidator");
                    return testValidator.getRecordedVariables(CallResult.this.getInstance(), BpelTestCase.this.processQName);
                }
            });
        }

        public List<PartnerLinkRuntime> getPartnerLInks() {
            CommandService commandService = (CommandService)BpelTestCase.this.getEnvironmentFactory().get(CommandService.class);
            return (List)commandService.execute((Command)new Command<List<PartnerLinkRuntime>>(){

                public List<PartnerLinkRuntime> execute(Environment environment) throws Exception {
                    TestValidator testValidator = (TestValidator)environment.get("testValidator");
                    return testValidator.getRecordedPartnerLinks(CallResult.this.getInstance(), BpelTestCase.this.processQName);
                }
            });
        }

        public List<String> getEvents() {
            CommandService commandService = (CommandService)BpelTestCase.this.getEnvironmentFactory().get(CommandService.class);
            return (List)commandService.execute((Command)new Command<List<String>>(){

                public List<String> execute(Environment environment) throws Exception {
                    TestValidator testValidator = (TestValidator)environment.get("testValidator");
                    return testValidator.getRecordedEvents(CallResult.this.getInstance(), BpelTestCase.this.processQName);
                }
            });
        }

        public long getEndTime() {
            return this.endTime;
        }

        public BpelExecution getInstance() {
            return EnvTool.getRepository().getInstance(this.processInstanceUUID);
        }

        public ProcessInstanceUUID getProcessInstanceUUID() {
            return this.processInstanceUUID;
        }

        public String toString() {
            return CallResult.class.getName() + "[instance: " + this.processInstanceUUID + ", messageCarrier: " + this.messageCarrier + ", endTime: " + this.endTime + "]";
        }
    }
}

