/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services;

import java.util.Set;
import junit.framework.Assert;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.full.impl.ProcessFullInstanceImpl;
import org.ow2.orchestra.facade.uuid.IdFactory;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.services.Archivable;
import org.ow2.orchestra.services.Archiver;
import org.ow2.orchestra.test.EnvironmentTestCase;
import org.ow2.orchestra.util.EnvTool;

public class HistoryTest
extends EnvironmentTestCase {
    private int processFullInstanceSize;

    public void archiveInstance(final ProcessFullInstance processFullInstance) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Archiver archiver = EnvTool.getArchiver();
                archiver.archive((Archivable)processFullInstance);
                return null;
            }
        });
    }

    public void testFindActivityInstance() {
        ProcessDefinitionUUID processUUID = IdFactory.getNewProcessUUID((String)"http://www.example.org/HistoryTest/", (String)"historytest");
        ProcessInstanceUUID instanceUUID = IdFactory.getNewInstanceUUID();
        ProcessFullInstanceImpl newProcessFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Set processFullInstanceSet = EnvTool.getHistoryQueriers().findProcessInstances();
                HistoryTest.this.processFullInstanceSize = processFullInstanceSet.size();
                return null;
            }
        });
        this.archiveInstance((ProcessFullInstance)newProcessFullInstance);
        commandService.execute((Command)new Command<Object>((ProcessFullInstance)newProcessFullInstance){
            final /* synthetic */ ProcessFullInstance val$newProcessFullInstance;
            {
                this.val$newProcessFullInstance = processFullInstance;
            }

            public Object execute(Environment environment) throws Exception {
                Set processFullInstanceSet = EnvTool.getHistoryQueriers().findProcessInstances();
                Assert.assertEquals((int)(HistoryTest.this.processFullInstanceSize + 1), (int)processFullInstanceSet.size());
                ProcessFullInstance processInstance = EnvTool.getHistoryQueriers().getProcessInstance(this.val$newProcessFullInstance.getUUID());
                Assert.assertNotNull((Object)processInstance);
                return null;
            }
        });
    }

    public void testGetNonExistentProcessInstance() {
        final ProcessInstanceUUID instanceUUID = IdFactory.getNewInstanceUUID();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                ProcessFullInstance processInstance = EnvTool.getHistoryQueriers().getProcessInstance(instanceUUID);
                Assert.assertNull((Object)processInstance);
                return null;
            }
        });
    }
}

