/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services;

import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.ow2.orchestra.facade.data.def.ActivityDefinitionData;
import org.ow2.orchestra.facade.data.def.ProcessDefinitionData;
import org.ow2.orchestra.facade.data.runtime.ActivityInstanceData;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.full.impl.ProcessFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.UnknownActivityFullInstanceImpl;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.IdFactory;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.services.Archivable;
import org.ow2.orchestra.services.Recorder;
import org.ow2.orchestra.test.services.AbstractQuerierTest;
import org.ow2.orchestra.util.EnvTool;

public class JournalTest
extends AbstractQuerierTest {
    public void saveNewProcessInstance(ProcessInstance processInstance) {
        ProcessDefinitionData processDefinitionData = new ProcessDefinitionData(processInstance.getProcessDefinitionUUID(), "queriertest1", "http://www.example.org/QuerierTest/");
        ProcessInstanceData processInstanceData = new ProcessInstanceData(processDefinitionData, processInstance.getProcessInstanceUUID(), ActivityState.RUNNING);
        this.recordInstanceStarted(processInstanceData);
    }

    public void saveNewActivityInstance(ActivityInstance activityInstance) {
        ProcessDefinitionData processDefinitionData = new ProcessDefinitionData(activityInstance.getProcessDefinitionUUID(), "queriertest1", "http://www.example.org/QuerierTest/");
        ProcessInstanceData processInstanceData = new ProcessInstanceData(processDefinitionData, activityInstance.getProcessInstanceUUID(), ActivityState.RUNNING);
        ActivityDefinitionUUID uuid = new ActivityDefinitionUUID(activityInstance.getProcessDefinitionUUID(), 3, ActivityType.UNKNOWN_ACTIVITY, "Name_Test");
        ActivityDefinitionUUID encloserUUID = new ActivityDefinitionUUID(activityInstance.getProcessDefinitionUUID(), 4, ActivityType.UNKNOWN_ACTIVITY, "Name_Encloser_Test");
        ActivityDefinitionData activityDefinitionData = new ActivityDefinitionData(processDefinitionData, uuid, encloserUUID, ActivityType.SEQUENCE, "name");
        ActivityInstanceData activityInstanceData = new ActivityInstanceData(activityDefinitionData, processInstanceData, activityInstance.getUUID(), (ActivityInstanceUUID)activityInstance.getProcessInstanceUUID());
        this.recordInstanceStarted(activityInstanceData);
    }

    public void saveNewActivityInstanceBadEncloser(ActivityInstance activityInstance) {
        ProcessDefinitionData processDefinitionData = new ProcessDefinitionData(activityInstance.getProcessDefinitionUUID(), "queriertest1", "http://www.example.org/QuerierTest/");
        ProcessInstanceData processInstanceData = new ProcessInstanceData(processDefinitionData, activityInstance.getProcessInstanceUUID(), ActivityState.RUNNING);
        ActivityDefinitionUUID uuid = new ActivityDefinitionUUID(activityInstance.getProcessDefinitionUUID(), 5, ActivityType.UNKNOWN_ACTIVITY, "Name_Test");
        ActivityDefinitionUUID encloserUUID = new ActivityDefinitionUUID(activityInstance.getProcessDefinitionUUID(), 6, ActivityType.UNKNOWN_ACTIVITY, "Name_Encloser_Test");
        ActivityDefinitionData activityDefinitionData = new ActivityDefinitionData(processDefinitionData, uuid, encloserUUID, ActivityType.SEQUENCE, "name");
        ActivityInstanceData activityInstanceData = new ActivityInstanceData(activityDefinitionData, processInstanceData, activityInstance.getUUID(), activityInstance.getUUID());
        this.recordInstanceStarted(activityInstanceData);
    }

    public void recordInstanceStarted(ActivityInstanceData aID) {
        final ActivityInstanceData activityInstanceData = aID;
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Recorder recorder = EnvTool.getRecorder();
                recorder.recordActivityStarted(activityInstanceData);
                return null;
            }
        });
    }

    public void recordInstanceStarted(ProcessInstanceData pID) {
        final ProcessInstanceData processInstanceData = pID;
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Recorder recorder = EnvTool.getRecorder();
                recorder.recordInstanceStarted(processInstanceData);
                return null;
            }
        });
    }

    public void recordInstanceUpdated(ProcessInstanceData pID) {
        final ProcessInstanceData processInstanceData = pID;
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Recorder recorder = EnvTool.getRecorder();
                recorder.recordInstanceUpdated(processInstanceData);
                return null;
            }
        });
    }

    public void removeProcessInstance(final ProcessInstance processInstance) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Recorder recorder = EnvTool.getRecorder();
                recorder.remove((Archivable)EnvTool.getQuerier().getProcessInstance(processInstance.getUUID()));
                return null;
            }
        });
    }

    public void testFindProcessInstance() {
        ProcessDefinitionUUID processUUID = IdFactory.getNewProcessUUID((String)"http://www.example.org/QuerierTest/", (String)"queriertest1");
        ProcessInstanceUUID instanceUUID = IdFactory.getNewInstanceUUID();
        ProcessFullInstanceImpl newProcessFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                JournalTest.this.setNbProcessInstances(processFullInstanceSet.size());
                return null;
            }
        });
        this.saveNewProcessInstance((ProcessInstance)newProcessFullInstance);
        commandService.execute((Command)new Command<Object>((ProcessFullInstance)newProcessFullInstance){
            final /* synthetic */ ProcessFullInstance val$newProcessFullInstance;
            {
                this.val$newProcessFullInstance = processFullInstance;
            }

            public Object execute(Environment environment) throws Exception {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                Assert.assertEquals((long)(JournalTest.this.getNbProcessInstances() + 1L), (long)processFullInstanceSet.size());
                ProcessFullInstance lastProcessFullInstance = null;
                for (ProcessFullInstance processFullInstance : processFullInstanceSet) {
                    if (!processFullInstance.getUUID().equals((Object)this.val$newProcessFullInstance.getUUID())) continue;
                    lastProcessFullInstance = processFullInstance;
                    break;
                }
                if (lastProcessFullInstance == null) {
                    Assert.fail((String)"process instance not found");
                }
                Assert.assertEquals((Object)this.val$newProcessFullInstance.getProcessDefinitionUUID(), (Object)lastProcessFullInstance.getProcessDefinitionUUID());
                Assert.assertEquals((Object)this.val$newProcessFullInstance.getProcessInstanceUUID(), (Object)lastProcessFullInstance.getProcessInstanceUUID());
                Assert.assertEquals((Object)this.val$newProcessFullInstance.getUUID(), (Object)lastProcessFullInstance.getUUID());
                return null;
            }
        });
        this.removeProcessInstance((ProcessInstance)newProcessFullInstance);
    }

    public void testFindActivityInstance() {
        ProcessDefinitionUUID processUUID = IdFactory.getNewProcessUUID((String)"http://www.example.org/QuerierTest/", (String)"queriertest1");
        final ProcessInstanceUUID instanceUUID = IdFactory.getNewInstanceUUID();
        ProcessFullInstanceImpl newProcessFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                JournalTest.this.setNbProcessInstances(processFullInstanceSet.size());
                Set activityFullInstanceSet = EnvTool.getQuerier().findActivityInstances(instanceUUID);
                JournalTest.this.setNbActivityInstances(activityFullInstanceSet.size());
                return null;
            }
        });
        this.saveNewProcessInstance((ProcessInstance)newProcessFullInstance);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                Assert.assertEquals((long)(JournalTest.this.getNbProcessInstances() + 1L), (long)processFullInstanceSet.size());
                return null;
            }
        });
        ActivityInstanceUUID activityInstanceUUID = IdFactory.getNewActivityUUID();
        ActivityDefinitionUUID activityDefinitionUUID = IdFactory.getNewActivityDefUUID((ProcessDefinitionUUID)processUUID, (int)1);
        UnknownActivityFullInstanceImpl newActivityFullInstance = new UnknownActivityFullInstanceImpl(activityInstanceUUID, activityDefinitionUUID, processUUID, instanceUUID);
        this.saveNewActivityInstance((ActivityInstance)newActivityFullInstance);
        commandService.execute((Command)new Command<Object>((ActivityFullInstance)newActivityFullInstance){
            final /* synthetic */ ActivityFullInstance val$newActivityFullInstance;
            {
                this.val$newActivityFullInstance = activityFullInstance;
            }

            public Object execute(Environment environment) throws Exception {
                Set activityFullInstanceSet = EnvTool.getQuerier().findActivityInstances(instanceUUID);
                Assert.assertEquals((long)(JournalTest.this.getNbActivityInstances() + 2L), (long)activityFullInstanceSet.size());
                Iterator it = activityFullInstanceSet.iterator();
                ActivityFullInstance lastActivityFullInstance = (ActivityFullInstance)it.next();
                if (lastActivityFullInstance.getType().equals((Object)ActivityType.PROCESS)) {
                    lastActivityFullInstance = (ActivityFullInstance)it.next();
                }
                Assert.assertEquals((Object)this.val$newActivityFullInstance.getProcessDefinitionUUID(), (Object)lastActivityFullInstance.getProcessDefinitionUUID());
                Assert.assertEquals((Object)this.val$newActivityFullInstance.getProcessInstanceUUID(), (Object)lastActivityFullInstance.getProcessInstanceUUID());
                Assert.assertEquals((Object)this.val$newActivityFullInstance.getUUID(), (Object)lastActivityFullInstance.getUUID());
                return null;
            }
        });
        this.removeProcessInstance((ProcessInstance)newProcessFullInstance);
    }

    public void testBadEncloser() {
        ProcessDefinitionUUID processUUID = IdFactory.getNewProcessUUID((String)"http://www.example.org/QuerierTest/", (String)"queriertest1");
        ProcessInstanceUUID instanceUUID = IdFactory.getNewInstanceUUID();
        ProcessFullInstanceImpl newProcessFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                JournalTest.this.setNbProcessInstances(processFullInstanceSet.size());
                return null;
            }
        });
        this.saveNewProcessInstance((ProcessInstance)newProcessFullInstance);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                Assert.assertEquals((long)(JournalTest.this.getNbProcessInstances() + 1L), (long)processFullInstanceSet.size());
                return null;
            }
        });
        ActivityInstanceUUID activityInstanceUUID = IdFactory.getNewActivityUUID();
        ActivityDefinitionUUID activityDefinitionUUID = IdFactory.getNewActivityDefUUID((ProcessDefinitionUUID)processUUID, (int)1);
        UnknownActivityFullInstanceImpl newActivityFullInstance = new UnknownActivityFullInstanceImpl(activityInstanceUUID, activityDefinitionUUID, processUUID, instanceUUID);
        try {
            this.saveNewActivityInstanceBadEncloser((ActivityInstance)newActivityFullInstance);
            Assert.fail((String)"Expected Exception");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        this.removeProcessInstance((ProcessInstance)newProcessFullInstance);
    }

    public void testSuspendProcessInstance() {
        ProcessDefinitionUUID processUUID = IdFactory.getNewProcessUUID((String)"http://www.example.org/QuerierTest/", (String)"queriertest1");
        ProcessInstanceUUID instanceUUID = IdFactory.getNewInstanceUUID();
        ProcessFullInstanceImpl newProcessFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                JournalTest.this.setNbProcessInstances(processFullInstanceSet.size());
                return null;
            }
        });
        ProcessDefinitionData processDefinitionData = new ProcessDefinitionData(newProcessFullInstance.getProcessDefinitionUUID(), "queriertest1", "http://www.example.org/QuerierTest/");
        ProcessInstanceData processInstanceData = new ProcessInstanceData(processDefinitionData, newProcessFullInstance.getProcessInstanceUUID(), ActivityState.RUNNING);
        this.recordInstanceStarted(processInstanceData);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                Assert.assertEquals((long)(JournalTest.this.getNbProcessInstances() + 1L), (long)processFullInstanceSet.size());
                return null;
            }
        });
        processInstanceData = new ProcessInstanceData(processDefinitionData, newProcessFullInstance.getProcessInstanceUUID(), ActivityState.SUSPENDED);
        this.recordInstanceUpdated(processInstanceData);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances(ActivityState.SUSPENDED);
                Assert.assertEquals((int)1, (int)processFullInstanceSet.size());
                return null;
            }
        });
        this.removeProcessInstance((ProcessInstance)newProcessFullInstance);
    }
}

