/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.runtime;

import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.test.wsutils.WaitWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class TestInstanceSuspendInInvoke
extends BpelTestCase {
    public TestInstanceSuspendInInvoke() {
        super("http://orchestra.ow2.org/SuspendInInvokeTest", "SuspendInInvokeTest");
    }

    public void testSuspendInInvoke() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    private void deleteInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                TestInstanceSuspendInInvoke.this.deleteInstance(callResult);
                return null;
            }
        });
    }

    private void suspendInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                callResult.getInstance().suspendInstance();
                return null;
            }
        });
    }

    private void resumeInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                callResult.getInstance().resumeInstance();
                return null;
            }
        });
    }

    public void launch() {
        String message;
        JobExecutor jobExecutor = (JobExecutor)this.getEnvironmentFactory().get(JobExecutor.class);
        String expectedResponse = message = UUID.randomUUID().toString();
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        WaitWS waitWS = new WaitWS();
        WSRepository.addWS(WaitWS.PORTTYPE_QNAME, waitWS);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("message", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PortType");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "SuspendInInvokeTestOperation");
        this.suspendInstanceMethod(callResult);
        TestInstanceSuspendInInvoke.assertEquals((int)0, (int)waitWS.getQueueLength());
        jobExecutor.stop();
        this.resumeInstanceMethod(callResult);
        TestInstanceSuspendInInvoke.assertEquals((int)0, (int)waitWS.getQueueLength());
        jobExecutor.start();
        while (waitWS.getQueueLength() == 0) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.suspendInstanceMethod(callResult);
        TestInstanceSuspendInInvoke.assertEquals((int)1, (int)waitWS.getQueueLength());
        waitWS.releaseAll();
        TestInstanceSuspendInInvoke.assertEquals((String)"", (String)saveWS.getBuffer());
        this.resumeInstanceMethod(callResult);
        this.deleteInstanceMethod(callResult);
        TestInstanceSuspendInInvoke.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        WSRepository.removeWS(WaitWS.PORTTYPE_QNAME);
    }
}

