/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.threadmodel.greetingInOutSeparate;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class GreetingInOutSeparateTest
extends BpelTestCase {
    public GreetingInOutSeparateTest() {
        super("http://example.com/greeting", "greetingInOutSeparate");
    }

    public void testGreetingInOutSeparate() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource("GreetingInOutSeparate.bpel"), ((Object)((Object)this)).getClass().getResource("GreetingInOutSeparate.wsdl"));
    }

    public long launch() {
        HashMap<String, Element> helloParts = new HashMap<String, Element>();
        helloParts.put("name", BpelXmlUtil.createElementWithContent((String)"Mark"));
        QName portTypeQName = new QName(this.getProcessNamespace(), "greeterPT");
        final BpelTestCase.CallResult callResult = this.call(helloParts, portTypeQName, "hello");
        GreetingInOutSeparateTest.assertFalse((boolean)callResult.getMessageCarrier().hasMessage());
        HashMap<String, Element> goodByeParts = new HashMap<String, Element>();
        goodByeParts.put("name", BpelXmlUtil.createElementWithContent((String)"John"));
        this.call(goodByeParts, portTypeQName, "goodbye");
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                MessageVariable replyMessage = callResult.getMessageCarrier().getMessage();
                Assert.assertNotNull((Object)replyMessage);
                Assert.assertNotNull((Object)replyMessage.getPartValue("name"));
                Assert.assertEquals((String)replyMessage.getPartValue("name").getTextContent(), (String)"John");
                GreetingInOutSeparateTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }
}

