/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.dom.DOMSource;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SOAPUtil {
    private static SOAPConnectionFactory conFactory;
    private static MessageFactory messagefactory;

    private SOAPUtil() {
    }

    private static synchronized SOAPConnectionFactory getSOAPConnectionFactory() {
        if (conFactory == null) {
            try {
                conFactory = SOAPConnectionFactory.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return conFactory;
    }

    private static synchronized MessageFactory getMessageFactory() {
        if (messagefactory == null) {
            try {
                messagefactory = MessageFactory.newInstance("SOAP 1.1 Protocol");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return messagefactory;
    }

    private static SOAPMessage getSOAPMessageFromDocument(Document document) {
        SOAPMessage soapMessage = null;
        try {
            soapMessage = SOAPUtil.getMessageFactory().createMessage();
            SOAPPart soapPart = soapMessage.getSOAPPart();
            soapPart.setContent(new DOMSource(document));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception when creating a SOAPMessage from document : " + document, e);
        }
        return soapMessage;
    }

    public static SOAPMessage buildSOAPMessage(Document document, String soapAction) {
        SOAPMessage soapMessage = null;
        try {
            soapMessage = SOAPUtil.getMessageFactory().createMessage();
            MimeHeaders hd = soapMessage.getMimeHeaders();
            hd.addHeader("SOAPAction", soapAction);
            SOAPPart soapPart = soapMessage.getSOAPPart();
            SOAPEnvelope enveloppe = soapPart.getEnvelope();
            enveloppe.addNamespaceDeclaration("env", "http://schemas.xmlsoap.org/soap/envelope/");
            SOAPBody body = enveloppe.getBody();
            body.addDocument(document);
            soapMessage.saveChanges();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while building a SOAPMessage", e);
        }
        return soapMessage;
    }

    public static SOAPMessage buildDocumentSOAPMessage(String soapAction, Element part) {
        Document document = null;
        try {
            document = XmlUtil.getNewDocument();
            Node importedPart = document.importNode(part, true);
            document.appendChild(importedPart);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while building Rpc SOAP Message", e);
        }
        return SOAPUtil.buildSOAPMessage(document, soapAction);
    }

    public static SOAPMessage buildDocumentSOAPMessage(String soapAction, String part) {
        Document doc = XmlUtil.getDocumentFromString(part);
        return SOAPUtil.buildSOAPMessage(doc, soapAction);
    }

    public static SOAPMessage call(SOAPMessage soapMessage, String endpoint) {
        SOAPMessage response = null;
        SOAPConnection connection = null;
        try {
            connection = SOAPUtil.getSOAPConnectionFactory().createConnection();
            response = connection.call(soapMessage, endpoint);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while performing call to " + endpoint, e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return response;
    }
}

