/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.correlation.checkCorrelation;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.correlation.CorrelationTestCase;
import org.ow2.orchestra.test.correlation.checkCorrelation.CorrelationWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class CheckCorrelationTest
extends CorrelationTestCase {
    public CheckCorrelationTest() {
        super("http://example.com/checkCorrelation", "checkCorrelation");
    }

    public void testCheckCorrelationRequestResponse() {
        this.deploy(false);
        this.launch(false);
        this.undeploy();
    }

    public void testCheckCorrelationBadResponse() {
        this.deploy(true);
        this.launch(true);
        this.undeploy();
    }

    public void testCheckCorrelationBadRequest() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "2.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        WSRepository.addWS(CorrelationWS.PORTTYPE_QNAME, new CorrelationWS("Valid", false));
        this.launch(true);
        this.undeploy();
    }

    public void deploy(boolean invokeChangeCS) {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        WSRepository.addWS(CorrelationWS.PORTTYPE_QNAME, new CorrelationWS("Valid", invokeChangeCS));
    }

    public void undeploy() {
        WSRepository.removeWS(CorrelationWS.PORTTYPE_QNAME);
        super.undeploy();
    }

    public long launch(boolean correlationExceptionExpected) {
        String auctionId = "1";
        String shippingCosts = "1";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("shippingCosts", BpelXmlUtil.createElementWithContent((String)"1"));
        parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)"1"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        if (!correlationExceptionExpected) {
            this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
            CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
            commandService.execute((Command)new Command<Object>(){

                public Object execute(Environment environment) throws Exception {
                    Assert.assertNotNull(callResult.getVariables());
                    Assert.assertEquals((int)1, (int)callResult.getVariables().size());
                    String expected = "1-1-1-1Valid";
                    Object result = CheckCorrelationTest.this.getVariableValue(callResult, "result");
                    CheckCorrelationTest.this.assertResult(result, "1-1-1-1Valid");
                    CheckCorrelationTest.this.deleteInstance(callResult);
                    return null;
                }
            });
        } else {
            BpelFaultException bfe = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), BpelFaultException.BpelFault.correlationViolation);
            this.deleteInstances(1);
            Assert.assertNotNull((Object)bfe);
        }
        long endTime = System.currentTimeMillis();
        return endTime;
    }

    private void assertResult(Object o, String expected) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((String)"result is not an instance of Element", (boolean)(o instanceof Element));
        Element result = (Element)o;
        Assert.assertEquals((String)expected, (String)result.getTextContent());
    }
}

