/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.runtime;

import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.deployment.Deployer;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.full.ScopeActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.SequenceActivityFullInstance;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public abstract class AbstractEventHandlerTest
extends BpelTestCase {
    private final long time = 5L;
    private final QName onAlarmQName = new QName("http://orchestra.ow2.org/OnAlarmTest", "OnAlarmTest");
    private final QName onEventQName = new QName("http://example.com/onEvent", "onEvent");

    abstract Querier getQuerier();

    private void deleteInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                AbstractEventHandlerTest.this.deleteInstance(callResult);
                return null;
            }
        });
    }

    public void testOnAlarmEvent() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.onAlarmQName.getLocalPart() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.onAlarmQName.getLocalPart() + ".wsdl"));
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message + message;
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("duration", BpelXmlUtil.createElementWithContent((String)("PT" + this.time + "S")));
        parts.put("message", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName(this.onAlarmQName.getNamespaceURI(), this.onAlarmQName.getLocalPart() + "PortType");
        String operationName = "OnAlarmTestOperation";
        final BpelTestCase.CallResult result = this.call(parts, portTypeQName, "OnAlarmTestOperation", this.onAlarmQName);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                ProcessFullInstance processFullInstance = AbstractEventHandlerTest.this.getQuerier().getProcessInstance(result.getProcessInstanceUUID());
                Assert.assertNotNull((Object)processFullInstance);
                Assert.assertNotNull((Object)processFullInstance.getEventInstances());
                Assert.assertEquals((int)2, (int)processFullInstance.getEventInstances().size());
                ScopeActivityFullInstance eventScopeInstance = (ScopeActivityFullInstance)processFullInstance.getEventInstances().get(0);
                Assert.assertNotNull((Object)eventScopeInstance.getEventInstances());
                Assert.assertEquals((int)0, (int)eventScopeInstance.getEventInstances().size());
                return null;
            }
        });
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod(result);
        this.undeploy(this.onAlarmQName);
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }

    public void undeploy(final QName processQName) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Deployer deployer = new Deployer();
                deployer.undeploy(processQName, environment);
                return null;
            }
        });
    }

    public void testOnEvent() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.onEventQName.getLocalPart() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.onEventQName.getLocalPart() + ".wsdl"));
        QName portTypeQName = new QName(this.onEventQName.getNamespaceURI(), this.onEventQName.getLocalPart() + "PT");
        HashMap<String, Element> parts1 = new HashMap<String, Element>();
        parts1.put("id", BpelXmlUtil.createElementWithContent((String)"0"));
        final BpelTestCase.CallResult callResult1 = this.call(parts1, portTypeQName, "init", this.onEventQName);
        this.call(parts1, portTypeQName, "incrInt1", this.onEventQName).getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "incrInt2", this.onEventQName).getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "incrInt1", this.onEventQName).getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "incrInt1", this.onEventQName).getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "incrInt1", this.onEventQName).getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "incrInt2", this.onEventQName).getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "validate", this.onEventQName).getMessageCarrier().getMessage();
        final MessageVariable reply1 = callResult1.getMessageCarrier().getMessage();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                int instance1int1 = Integer.parseInt(reply1.getPartValue("int1").getTextContent());
                int instance1int2 = Integer.parseInt(reply1.getPartValue("int2").getTextContent());
                Assert.assertEquals((int)4, (int)instance1int1);
                Assert.assertEquals((int)2, (int)instance1int2);
                ProcessFullInstance processFullInstance = AbstractEventHandlerTest.this.getQuerier().getProcessInstance(callResult1.getProcessInstanceUUID());
                Assert.assertNotNull((Object)processFullInstance);
                processFullInstance = (ProcessFullInstance)processFullInstance.fullCopy();
                Assert.assertNotNull((Object)processFullInstance.getEventInstances());
                Assert.assertEquals((int)0, (int)processFullInstance.getEventInstances().size());
                SequenceActivityFullInstance enclosedSequence = (SequenceActivityFullInstance)processFullInstance.getEnclosedActivity();
                Assert.assertEquals((int)4, (int)enclosedSequence.getEnclosedActivities().size());
                ScopeActivityFullInstance eventScopeInstance = (ScopeActivityFullInstance)enclosedSequence.getEnclosedActivities().get(2);
                Assert.assertNotNull((Object)eventScopeInstance.getEventInstances());
                Assert.assertEquals((int)6, (int)eventScopeInstance.getEventInstances().size());
                AbstractEventHandlerTest.this.deleteInstance(callResult1);
                return null;
            }
        });
        this.undeploy(this.onEventQName);
    }
}

