/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Final<T>
implements Serializable {
    private static final long serialVersionUID = 48705032925395418L;
    private final AtomicReference<T> atomicReference = new AtomicReference();

    public String toString() {
        return this.isInitialized() ? this.getValue().toString() : "<uninitialized>";
    }

    protected T getValue() {
        return this.atomicReference.get();
    }

    protected void setValue(T t) {
        this.atomicReference.set(t);
    }

    public void init(T t) {
        Misc.checkArgsNotNull(t);
        if (!this.atomicReference.compareAndSet(null, t)) {
            throw new IllegalStateException("Final variable already set to: " + t);
        }
    }

    public T get() {
        return this.atomicReference.get();
    }

    public boolean isInitialized() {
        return this.atomicReference.get() != null;
    }
}

