/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test;

import java.util.logging.Logger;
import junit.framework.TestCase;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.env.EnvFactoryRepository;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.test.TestInvoker;
import org.ow2.orchestra.test.TestValidatorImpl;

public abstract class EnvironmentTestCase
extends TestCase {
    private static Logger LOG = Logger.getLogger(EnvironmentTestCase.class.getName());
    private boolean createdEnvFactory = false;

    protected EnvironmentTestCase() {
        EnvironmentTestCase.setSystemProperties();
    }

    public static DefaultEnvXMLGenerator getBpelTestEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = new DefaultEnvXMLGenerator();
        envGenerator.setApplicationEntry("serviceInvoker", TestInvoker.class);
        envGenerator.setApplicationEntry("testValidator", TestValidatorImpl.class);
        return envGenerator;
    }

    public DefaultEnvXMLGenerator getEnvGenerator() {
        return EnvironmentTestCase.getBpelTestEnvGenerator();
    }

    public synchronized EnvironmentFactory getEnvironmentFactory() {
        if (EnvFactoryRepository.get() == null) {
            try {
                DefaultEnvXMLGenerator envGenerator = this.getEnvGenerator();
                envGenerator.setApplicationEntry("serviceInvoker", TestInvoker.class);
                envGenerator.setApplicationEntry("testValidator", TestValidatorImpl.class);
                EnvFactoryRepository.set((EnvironmentFactory)envGenerator.createEnvironmentFactory());
                this.createdEnvFactory = true;
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException((Throwable)e);
            }
        }
        return EnvFactoryRepository.get();
    }

    protected void tearDown() throws Exception {
        if (this.createdEnvFactory) {
            EnvFactoryRepository.get().close();
            EnvFactoryRepository.set(null);
        }
        LOG.info("=== ending " + this.getName() + " =============================\n");
        super.tearDown();
    }

    public void setUp() throws Exception {
        LOG.info("=== starting " + this.getName() + " =============================");
    }

    public static void setSystemProperty(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    public static void setSystemProperties() {
        EnvironmentTestCase.setSystemProperty("javax.xml.stream.XMLEventFactory", "com.ctc.wstx.stax.WstxEventFactory");
        EnvironmentTestCase.setSystemProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        EnvironmentTestCase.setSystemProperty("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
    }
}

