/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.if_;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class IfTest
extends BpelTestCase {
    public IfTest() {
        super("http://orchestra.ow2.org/if", "if");
    }

    public void testIf() {
        this.deploy();
        this.launch("1", "if");
        this.launch("2", "elseif1");
        this.launch("3", "elseif2");
        this.launch("4", "else");
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch(String condition, final String expectedResult) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("condition", BpelXmlUtil.createElementWithContent((String)condition));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNotNull(callResult.getVariables());
                Assert.assertEquals((int)callResult.getVariables().size(), (int)1);
                Object result = IfTest.this.getVariableValue(callResult, "result");
                IfTest.this.assertString(result, expectedResult);
                IfTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }
}

