/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.def;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.CatchAllDefinition;
import org.ow2.orchestra.facade.def.CatchDefinition;
import org.ow2.orchestra.facade.def.CopyDefinition;
import org.ow2.orchestra.facade.def.CorrelationDefinition;
import org.ow2.orchestra.facade.def.CorrelationSetDefinition;
import org.ow2.orchestra.facade.def.ForDefinition;
import org.ow2.orchestra.facade.def.FromDefinition;
import org.ow2.orchestra.facade.def.FromPartDefinition;
import org.ow2.orchestra.facade.def.PartnerLinkDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.ToDefinition;
import org.ow2.orchestra.facade.def.ToPartDefinition;
import org.ow2.orchestra.facade.def.UntilDefinition;
import org.ow2.orchestra.facade.def.VariableDefinition;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.def.full.AssignActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.ElseFullDefinition;
import org.ow2.orchestra.facade.def.full.ElseIfFullDefinition;
import org.ow2.orchestra.facade.def.full.FlowActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.ForeachActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.IfActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.InvokeActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.OnAlarmFullDefinition;
import org.ow2.orchestra.facade.def.full.OnMessageFullDefinition;
import org.ow2.orchestra.facade.def.full.PickActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.def.full.ReceiveActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.RepeatUntilActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.ReplyActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.ScopeActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.SequenceActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.SourceFull;
import org.ow2.orchestra.facade.def.full.TargetFull;
import org.ow2.orchestra.facade.def.full.ThrowActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.WaitActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.WhileActivityFullDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.activities.wait.WaitTestCase;
import org.ow2.orchestra.util.Misc;

public abstract class AbstractSubTypesDefinitionTest
extends WaitTestCase {
    private ProcessFullDefinition processFullDefinitionDeployed;
    private Date beforeDeployDate;
    private Date afterDeployDate;

    public abstract Querier getQuerier();

    public AbstractSubTypesDefinitionTest(BpelTestCase.EnvironmentType environmentType) {
        super("http://orchestra.ow2.org/definitiontest", "definitiontest", environmentType);
    }

    public void testSubTypesDefinition() {
        this.beforeDeployDate = new Date(System.currentTimeMillis() / 1000L * 1000L);
        this.deploy();
        this.afterDeployDate = new Date((System.currentTimeMillis() / 1000L + 1L) * 1000L);
        this.undeploy();
        this.launch();
    }

    public void deploy() {
        String suffix = "-response";
        this.deploy(((Object)((Object)this)).getClass().getResource("definitiontest.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public void launch() {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = AbstractSubTypesDefinitionTest.this.getQuerier();
                QName qName = new QName(AbstractSubTypesDefinitionTest.this.getProcessNamespace(), AbstractSubTypesDefinitionTest.this.getProcessName());
                List processFullDefinitionList = querier.findProcessDefinitions(qName, ProcessState.UNDEPLOYED);
                Iterator processFullDefinitionIterator = processFullDefinitionList.iterator();
                Assert.assertTrue((boolean)processFullDefinitionIterator.hasNext());
                AbstractSubTypesDefinitionTest.this.processFullDefinitionDeployed = ((ProcessFullDefinition)processFullDefinitionIterator.next()).fullCopy();
                Assert.assertEquals((Object)ActivityType.PROCESS, (Object)AbstractSubTypesDefinitionTest.this.processFullDefinitionDeployed.getType());
                AbstractSubTypesDefinitionTest.this.checkProcessActivity((BpelActivityFullDefinition)AbstractSubTypesDefinitionTest.this.processFullDefinitionDeployed);
                Assert.assertEquals((Object)ActivityType.SEQUENCE, (Object)AbstractSubTypesDefinitionTest.this.processFullDefinitionDeployed.getEnclosedActivity().getType());
                AbstractSubTypesDefinitionTest.this.checkSequenceActivity(AbstractSubTypesDefinitionTest.this.processFullDefinitionDeployed.getEnclosedActivity());
                SequenceActivityFullDefinition sequenceActivityFullDefinition = (SequenceActivityFullDefinition)AbstractSubTypesDefinitionTest.this.processFullDefinitionDeployed.getEnclosedActivity();
                List activityFullDefinitionList = sequenceActivityFullDefinition.getEnclosedActivities();
                Iterator activityFullDefinitionIterator = activityFullDefinitionList.iterator();
                int checkedDefinitions = 0;
                block18: while (activityFullDefinitionIterator.hasNext()) {
                    BpelActivityFullDefinition activityFullDefinition = (BpelActivityFullDefinition)activityFullDefinitionIterator.next();
                    switch (activityFullDefinition.getType()) {
                        case SCOPE: {
                            AbstractSubTypesDefinitionTest.this.checkScopeActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case RECEIVE: {
                            AbstractSubTypesDefinitionTest.this.checkReceiveActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case REPLY: {
                            AbstractSubTypesDefinitionTest.this.checkReplyActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case ASSIGN: {
                            AbstractSubTypesDefinitionTest.this.checkAssignActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case WAIT: {
                            AbstractSubTypesDefinitionTest.this.checkWaitActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case WHILE: {
                            AbstractSubTypesDefinitionTest.this.checkWhileActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case REPEAT_UNTIL: {
                            AbstractSubTypesDefinitionTest.this.checkRepeatUntilActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case IF: {
                            AbstractSubTypesDefinitionTest.this.checkIfActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case PICK: {
                            AbstractSubTypesDefinitionTest.this.checkPickActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case FOR_EACH: {
                            AbstractSubTypesDefinitionTest.this.checkForeachActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case FLOW: {
                            AbstractSubTypesDefinitionTest.this.checkFlowActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case EMPTY: {
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case THROW: {
                            AbstractSubTypesDefinitionTest.this.checkThrowActivity(activityFullDefinition);
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case EXIT: {
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case COMPENSATE: {
                            ++checkedDefinitions;
                            continue block18;
                        }
                        case COMPENSATE_SCOPE: {
                            ++checkedDefinitions;
                            continue block18;
                        }
                    }
                    Assert.fail((String)("Unknown activity: " + activityFullDefinition.getType() + " - " + activityFullDefinition.getName()));
                }
                Assert.assertEquals((int)sequenceActivityFullDefinition.getEnclosedActivities().size(), (int)checkedDefinitions);
                return null;
            }
        });
    }

    public void checkProcessActivity(BpelActivityFullDefinition activityFullDefinition) {
        ProcessFullDefinition processActivityFullDefinition = (ProcessFullDefinition)activityFullDefinition.fullCopy();
        Assert.assertEquals((String)"definitiontest", (String)processActivityFullDefinition.getName());
        Assert.assertEquals((String)"http://orchestra.ow2.org/definitiontest", (String)processActivityFullDefinition.getNameSpace());
        Assert.assertEquals((String)"urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", (String)processActivityFullDefinition.getQueryLanguage());
        if (processActivityFullDefinition.getDeployedDate().getTime() < this.beforeDeployDate.getTime()) {
            Assert.fail((String)("Deployed Date is not correct: [Before deploy date:" + this.beforeDeployDate + ", deploy date:" + processActivityFullDefinition.getDeployedDate()));
        } else if (processActivityFullDefinition.getDeployedDate().getTime() > this.afterDeployDate.getTime()) {
            Assert.fail((String)("Deployed Date is not correct: [Deploy date:" + processActivityFullDefinition.getDeployedDate() + ", after deploy date: " + this.afterDeployDate));
        }
        List variableDefinitionList = processActivityFullDefinition.getVariables();
        List correlationSetDefinitionList = processActivityFullDefinition.getCorrelationSets();
        List partnerLinkDefinitionList = processActivityFullDefinition.getPartnerLinks();
        List messageExchangeList = processActivityFullDefinition.getMessageExchanges();
        Iterator variableDefinitionIterator = variableDefinitionList.iterator();
        Iterator correlationSetDefinitionIterator = correlationSetDefinitionList.iterator();
        Iterator partnerLinkDefinitionIterator = partnerLinkDefinitionList.iterator();
        Iterator messageExchangeIterator = messageExchangeList.iterator();
        int size = variableDefinitionList.size();
        while (variableDefinitionIterator.hasNext()) {
            VariableDefinition variableDefinition = (VariableDefinition)variableDefinitionIterator.next();
            if ("var0".equals(variableDefinition.getName())) {
                Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}InvMessage", (String)variableDefinition.getMessageType().toString());
                --size;
            }
            if ("var1".equals(variableDefinition.getName())) {
                Assert.assertEquals((String)"{http://www.w3.org/2001/XMLSchema}string", (String)variableDefinition.getType().toString());
                --size;
            }
            if ("var2".equals(variableDefinition.getName())) {
                Assert.assertEquals((String)"elementVar2", (String)variableDefinition.getElement().toString());
                --size;
            }
            if ("request".equals(variableDefinition.getName())) {
                Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}submitRequest", (String)variableDefinition.getMessageType().toString());
                --size;
            }
            if ("product".equals(variableDefinition.getName())) {
                Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}bigProduct", (String)variableDefinition.getElement().toString());
                --size;
            }
            if ("product01".equals(variableDefinition.getName())) {
                Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}bigProduct", (String)variableDefinition.getElement().toString());
                --size;
            }
            if ("product02".equals(variableDefinition.getName())) {
                Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}bigProduct", (String)variableDefinition.getElement().toString());
                --size;
            }
            if ("requestFromPart".equals(variableDefinition.getName())) {
                Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}receiveRequest", (String)variableDefinition.getMessageType().toString());
                --size;
            }
            if (!"bigProduct".equals(variableDefinition.getName())) continue;
            --size;
        }
        Assert.assertEquals((int)0, (int)size);
        size = correlationSetDefinitionList.size();
        while (correlationSetDefinitionIterator.hasNext()) {
            CorrelationSetDefinition correlationSetDefinition = (CorrelationSetDefinition)correlationSetDefinitionIterator.next();
            if ("correlationSet01".equals(correlationSetDefinition.getName())) {
                Iterator qameIterator = correlationSetDefinition.getProperties().iterator();
                int id = 1;
                while (qameIterator.hasNext()) {
                    QName qName = (QName)qameIterator.next();
                    Assert.assertEquals((String)("{http://orchestra.ow2.org/definitiontest}correlationSet01Id0" + id), (String)qName.toString());
                    ++id;
                }
                --size;
            }
            if ("correlationSet02".equals(correlationSetDefinition.getName())) {
                for (QName qName : correlationSetDefinition.getProperties()) {
                    Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}correlationSet02Id", (String)qName.toString());
                }
                --size;
            }
            if (!"auctionCS".equals(correlationSetDefinition.getName())) continue;
            for (QName qName : correlationSetDefinition.getProperties()) {
                Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}auctionId", (String)qName.toString());
            }
            --size;
        }
        Assert.assertEquals((int)0, (int)size);
        size = partnerLinkDefinitionList.size();
        int id = 1;
        while (partnerLinkDefinitionIterator.hasNext()) {
            PartnerLinkDefinition partnerLinkDefinition = (PartnerLinkDefinition)partnerLinkDefinitionIterator.next();
            if ("definitiontest01PL".equals(partnerLinkDefinition.getName())) {
                Assert.assertEquals((String)"role", (String)partnerLinkDefinition.getMyRole());
                Assert.assertEquals((String)("{http://orchestra.ow2.org/definitiontest}definitiontest0" + id + "LT"), (String)partnerLinkDefinition.getPartnerLinkType().toString());
                Assert.assertEquals((boolean)false, (boolean)partnerLinkDefinition.isInitializePartnerRole());
                Assert.assertNull((Object)partnerLinkDefinition.getPartnerRole());
                --size;
                ++id;
            }
            if (!"definitiontest02PL".equals(partnerLinkDefinition.getName())) continue;
            Assert.assertEquals((String)"role", (String)partnerLinkDefinition.getMyRole());
            Assert.assertEquals((String)("{http://orchestra.ow2.org/definitiontest}definitiontest0" + id + "LT"), (String)partnerLinkDefinition.getPartnerLinkType().toString());
            Assert.assertEquals((boolean)false, (boolean)partnerLinkDefinition.isInitializePartnerRole());
            Assert.assertNull((Object)partnerLinkDefinition.getPartnerRole());
            --size;
            ++id;
        }
        Assert.assertEquals((int)1, (int)size);
        size = 0;
        while (messageExchangeIterator.hasNext()) {
            String messageExchange = (String)messageExchangeIterator.next();
            Assert.assertEquals((String)("messageExchange0" + ++size), (String)messageExchange);
        }
        Assert.assertEquals((int)size, (int)messageExchangeList.size());
    }

    public void checkScopeActivity(BpelActivityFullDefinition activityFullDefinition) {
        ScopeActivityFullDefinition scopeActivityFullDefinition = (ScopeActivityFullDefinition)activityFullDefinition.fullCopy();
        if ("scope01".equals(scopeActivityFullDefinition.getName())) {
            List variableDefinitionList = scopeActivityFullDefinition.getVariables();
            List correlationSetDefinitionList = scopeActivityFullDefinition.getCorrelationSets();
            List partnerLinkDefinitionList = scopeActivityFullDefinition.getPartnerLinks();
            List messageExchangeList = scopeActivityFullDefinition.getMessageExchanges();
            List faultHandlersList = scopeActivityFullDefinition.getFaultHandlers();
            Iterator variableDefinitionIterator = variableDefinitionList.iterator();
            Iterator correlationSetDefinitionIterator = correlationSetDefinitionList.iterator();
            Iterator partnerLinkDefinitionIterator = partnerLinkDefinitionList.iterator();
            Iterator messageExchangeIterator = messageExchangeList.iterator();
            Iterator faultHandlersIterator = faultHandlersList.iterator();
            int size = variableDefinitionList.size();
            while (variableDefinitionIterator.hasNext()) {
                VariableDefinition variableDefinition = (VariableDefinition)variableDefinitionIterator.next();
                if (variableDefinition.getName().equals("scope01Var0")) {
                    Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}InvMessage", (String)variableDefinition.getMessageType().toString());
                    --size;
                }
                if (variableDefinition.getName().equals("scope01Var1")) {
                    Assert.assertEquals((String)"{http://www.w3.org/2001/XMLSchema}boolean", (String)variableDefinition.getType().toString());
                    --size;
                }
                if (!variableDefinition.getName().equals("scope01Var2")) continue;
                Assert.assertEquals((String)"elementScope01Var2", (String)variableDefinition.getElement().toString());
                --size;
            }
            Assert.assertEquals((int)0, (int)size);
            size = correlationSetDefinitionList.size();
            while (correlationSetDefinitionIterator.hasNext()) {
                CorrelationSetDefinition correlationSetDefinition = (CorrelationSetDefinition)correlationSetDefinitionIterator.next();
                if ("scope01CorrelationSet01".equals(correlationSetDefinition.getName())) {
                    for (QName qName : correlationSetDefinition.getProperties()) {
                        Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}scope01CorrelationSet01Id", (String)qName.toString());
                    }
                    --size;
                }
                if (!"scope01CorrelationSet02".equals(correlationSetDefinition.getName())) continue;
                Iterator qameIterator = correlationSetDefinition.getProperties().iterator();
                int id = 1;
                while (qameIterator.hasNext()) {
                    QName qName = (QName)qameIterator.next();
                    Assert.assertEquals((String)("{http://orchestra.ow2.org/definitiontest}scope01CorrelationSet02Id0" + id), (String)qName.toString());
                    ++id;
                }
                --size;
            }
            Assert.assertEquals((int)0, (int)size);
            size = 1;
            while (partnerLinkDefinitionIterator.hasNext()) {
                PartnerLinkDefinition partnerLinkDefinition = (PartnerLinkDefinition)partnerLinkDefinitionIterator.next();
                if (!("scope01Definitiontest0" + size + "PL").equals(partnerLinkDefinition.getName())) continue;
                Assert.assertEquals((String)"role", (String)partnerLinkDefinition.getMyRole());
                Assert.assertEquals((String)("{http://orchestra.ow2.org/definitiontest}definitiontest0" + size + "LT"), (String)partnerLinkDefinition.getPartnerLinkType().toString());
                Assert.assertEquals((boolean)false, (boolean)partnerLinkDefinition.isInitializePartnerRole());
                Assert.assertNull((Object)partnerLinkDefinition.getPartnerRole());
                ++size;
            }
            Assert.assertEquals((int)(size - 1), (int)partnerLinkDefinitionList.size());
            size = 0;
            while (messageExchangeIterator.hasNext()) {
                String messageExchange = (String)messageExchangeIterator.next();
                Assert.assertEquals((String)("scope01MessageExchange0" + ++size), (String)messageExchange);
            }
            Assert.assertEquals((int)size, (int)messageExchangeList.size());
            Assert.assertEquals((int)2, (int)faultHandlersList.size());
            size = 0;
            while (faultHandlersIterator.hasNext()) {
                ActivityDefinition activity = (ActivityDefinition)faultHandlersIterator.next();
                if (activity instanceof CatchAllDefinition) {
                    CatchAllDefinition cad = (CatchAllDefinition)activity;
                    Assert.assertNotNull((Object)cad.getUUID());
                } else if (activity instanceof CatchDefinition) {
                    CatchDefinition cd = (CatchDefinition)activity;
                    Assert.assertNotNull((Object)cd.getFaultName());
                    Assert.assertEquals((String)"InvMessage", (String)cd.getFaultName().getLocalPart());
                    Assert.assertNotNull((Object)cd.getUUID());
                } else {
                    Assert.fail((String)("unknown class: " + activity.getClass()));
                }
                ++size;
            }
            Assert.assertEquals((int)size, (int)faultHandlersList.size());
        } else if (scopeActivityFullDefinition.getName().startsWith("invokeToTest")) {
            this.checkInvokeActivity(scopeActivityFullDefinition.getEnclosedActivity());
            if ("invokeToTest1".equals(scopeActivityFullDefinition.getEnclosedActivity().getName())) {
                List faultHandlersList = scopeActivityFullDefinition.getFaultHandlers();
                Iterator faultHandlersIterator = faultHandlersList.iterator();
                Assert.assertEquals((int)2, (int)faultHandlersList.size());
                int size = 0;
                while (faultHandlersIterator.hasNext()) {
                    ActivityDefinition activity = (ActivityDefinition)faultHandlersIterator.next();
                    if (activity instanceof CatchAllDefinition) {
                        CatchAllDefinition cad = (CatchAllDefinition)activity;
                        Assert.assertNotNull((Object)cad.getUUID());
                    } else if (activity instanceof CatchDefinition) {
                        CatchDefinition cd = (CatchDefinition)activity;
                        Assert.assertNotNull((Object)cd.getFaultName());
                        Assert.assertEquals((String)"InvMessage", (String)cd.getFaultName().getLocalPart());
                        Assert.assertNotNull((Object)cd.getUUID());
                    } else {
                        Assert.fail((String)("unknown class: " + activity.getClass()));
                    }
                    ++size;
                }
                Assert.assertEquals((int)size, (int)faultHandlersList.size());
            }
        } else {
            Assert.fail((String)("Incorrect scope activity name: " + scopeActivityFullDefinition.getName()));
        }
    }

    public void checkSequenceActivity(BpelActivityFullDefinition activityFullDefinition) {
        SequenceActivityFullDefinition sequenceActivityFullDefinition = (SequenceActivityFullDefinition)activityFullDefinition.fullCopy();
        Assert.assertEquals((String)"sequence01", (String)sequenceActivityFullDefinition.getName());
        Assert.assertEquals((int)28, (int)sequenceActivityFullDefinition.getEnclosedActivities().size());
    }

    public void checkReceiveActivity(BpelActivityFullDefinition activityFullDefinition) {
        ReceiveActivityFullDefinition receiveActivityFullDefinition = (ReceiveActivityFullDefinition)activityFullDefinition.fullCopy();
        if ("receive01".equals(receiveActivityFullDefinition.getName())) {
            List correlationDefinitionList = receiveActivityFullDefinition.getCorrelationDefinitions();
            Assert.assertEquals((String)"submit", (String)receiveActivityFullDefinition.getOperation());
            Assert.assertEquals((String)"definitiontest01PL", (String)receiveActivityFullDefinition.getPartnerLink());
            Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}definitiontestPT", (String)receiveActivityFullDefinition.getPortType().toString());
            Assert.assertEquals((String)"messageExchange01", (String)receiveActivityFullDefinition.getMessageExchange());
            Assert.assertEquals((boolean)true, (boolean)receiveActivityFullDefinition.isCreateInstance());
            for (CorrelationDefinition correlationDefinition : correlationDefinitionList) {
                if (!"auctionCS".equals(correlationDefinition.getSet())) continue;
                Assert.assertEquals((String)"yes", (String)correlationDefinition.getInitiate());
            }
        } else if ("receive02".equals(receiveActivityFullDefinition.getName())) {
            List fromPartDefinitionList = receiveActivityFullDefinition.getFromPartDefinitions();
            for (FromPartDefinition fromPartDefinition : fromPartDefinitionList) {
                if (!"product".equals(fromPartDefinition.getPart())) continue;
                Assert.assertEquals((String)"requestFromPart", (String)fromPartDefinition.getToVariable());
            }
        } else {
            Assert.fail((String)("Inocrrect receive activity name: " + receiveActivityFullDefinition.getName()));
        }
    }

    private void checkReplyActivity(BpelActivityFullDefinition activityFullDefinition) {
        ReplyActivityFullDefinition replyActivityFullDefinition = (ReplyActivityFullDefinition)activityFullDefinition.fullCopy();
        if ("reply01".equals(replyActivityFullDefinition.getName())) {
            List correlationDefinitionList = replyActivityFullDefinition.getCorrelationDefinitions();
            Assert.assertEquals((String)"submit", (String)replyActivityFullDefinition.getOperation());
            Assert.assertEquals((String)"definitiontest01PL", (String)replyActivityFullDefinition.getPartnerLink());
            Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}definitiontestPT", (String)replyActivityFullDefinition.getPortType().toString());
            Assert.assertEquals((String)"messageExchange01", (String)replyActivityFullDefinition.getMessageExchange());
            for (CorrelationDefinition correlationDefinition : correlationDefinitionList) {
                if (!"auctionCS".equals(correlationDefinition.getSet())) continue;
                Assert.assertEquals((String)"no", (String)correlationDefinition.getInitiate());
            }
        } else if ("reply02".equals(replyActivityFullDefinition.getName())) {
            List toPartDefinitionList = replyActivityFullDefinition.getToPartDefinitions();
            Assert.assertEquals((String)"submitFromPart", (String)replyActivityFullDefinition.getOperation());
            Assert.assertEquals((String)"definitiontest01PL", (String)replyActivityFullDefinition.getPartnerLink());
            Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}definitiontestPT", (String)replyActivityFullDefinition.getPortType().toString());
            for (ToPartDefinition toPartDefinition : toPartDefinitionList) {
                if (!"product".equals(toPartDefinition.getPart())) continue;
                Assert.assertEquals((String)"requestFromPart", (String)toPartDefinition.getFromVariable());
            }
        } else {
            Assert.fail((String)("Incorrect reply activity name: " + replyActivityFullDefinition.getName()));
        }
    }

    public void checkAssignActivity(BpelActivityFullDefinition activityFullDefinition) {
        AssignActivityFullDefinition assignActivityFullDefinition = (AssignActivityFullDefinition)activityFullDefinition.fullCopy();
        List copyDefinitionList = assignActivityFullDefinition.getCopyDefinitions();
        Iterator copyDefinitionIterator = copyDefinitionList.iterator();
        if ("assign01".equals(assignActivityFullDefinition.getName())) {
            Assert.assertEquals((boolean)false, (boolean)assignActivityFullDefinition.isValidate());
            while (copyDefinitionIterator.hasNext()) {
                CopyDefinition copyDefinition = (CopyDefinition)copyDefinitionIterator.next();
                List fromDefinitionList = copyDefinition.getFromDefinitionList();
                List toDefinitionList = copyDefinition.getToDefinitionList();
                Iterator fromDefinitionIterator = fromDefinitionList.iterator();
                Iterator toDefinitionIterator = toDefinitionList.iterator();
                while (fromDefinitionIterator.hasNext()) {
                    FromDefinition fromDefinition = (FromDefinition)fromDefinitionIterator.next();
                    ToDefinition toDefinition = (ToDefinition)toDefinitionIterator.next();
                    Assert.assertEquals((Object)Variant.VAR, (Object)fromDefinition.getVariant());
                    Assert.assertEquals((String)"var1", (String)fromDefinition.getVariable());
                    Assert.assertEquals((Object)Variant.VAR, (Object)toDefinition.getVariant());
                    Assert.assertEquals((String)"var0", (String)toDefinition.getVariable());
                }
            }
        } else if ("assign02".equals(assignActivityFullDefinition.getName())) {
            Assert.assertEquals((boolean)false, (boolean)assignActivityFullDefinition.isValidate());
            while (copyDefinitionIterator.hasNext()) {
                CopyDefinition copyDefinition = (CopyDefinition)copyDefinitionIterator.next();
                List fromDefinitionList = copyDefinition.getFromDefinitionList();
                for (FromDefinition fromDefinition : fromDefinitionList) {
                    Assert.assertEquals((Object)Variant.LITERAL, (Object)fromDefinition.getVariant());
                    Assert.assertNotNull((Object)fromDefinition.getLiteral().getValue());
                }
            }
        } else if ("assign03".equals(assignActivityFullDefinition.getName())) {
            Assert.assertEquals((boolean)false, (boolean)assignActivityFullDefinition.isValidate());
            while (copyDefinitionIterator.hasNext()) {
                CopyDefinition copyDefinition = (CopyDefinition)copyDefinitionIterator.next();
                List fromDefinitionList = copyDefinition.getFromDefinitionList();
                List toDefinitionList = copyDefinition.getToDefinitionList();
                Iterator fromDefinitionIterator = fromDefinitionList.iterator();
                Iterator toDefinitionIterator = toDefinitionList.iterator();
                while (fromDefinitionIterator.hasNext()) {
                    FromDefinition fromDefinition = (FromDefinition)fromDefinitionIterator.next();
                    ToDefinition toDefinition = (ToDefinition)toDefinitionIterator.next();
                    Assert.assertEquals((Object)Variant.EXPR, (Object)fromDefinition.getVariant());
                    Assert.assertEquals((String)"http://orchestra.ow2.org/definitiontest", (String)fromDefinition.getExpressionLanguage());
                    Assert.assertEquals((String)"1+2+3+4+5+6+7+8+9+10", (String)fromDefinition.getExpression());
                    Assert.assertEquals((Object)Variant.EXPR, (Object)toDefinition.getVariant());
                    Assert.assertEquals((String)"http://orchestra.ow2.org/definitiontest/to", (String)toDefinition.getExpressionLanguage());
                    Assert.assertEquals((String)"10+9+8+7+6+5+4+3+2+1", (String)toDefinition.getExpression());
                }
            }
        } else if ("assign04".equals(assignActivityFullDefinition.getName())) {
            Assert.assertEquals((boolean)false, (boolean)assignActivityFullDefinition.isValidate());
            while (copyDefinitionIterator.hasNext()) {
                CopyDefinition copyDefinition = (CopyDefinition)copyDefinitionIterator.next();
                List fromDefinitionList = copyDefinition.getFromDefinitionList();
                List toDefinitionList = copyDefinition.getToDefinitionList();
                Iterator fromDefinitionIterator = fromDefinitionList.iterator();
                Iterator toDefinitionIterator = toDefinitionList.iterator();
                while (fromDefinitionIterator.hasNext()) {
                    FromDefinition fromDefinition = (FromDefinition)fromDefinitionIterator.next();
                    ToDefinition toDefinition = (ToDefinition)toDefinitionIterator.next();
                    Assert.assertEquals((Object)Variant.VAR, (Object)fromDefinition.getVariant());
                    Assert.assertEquals((String)"bigProduct", (String)fromDefinition.getVariable());
                    Assert.assertEquals((String)"tns:myElement/@myElementAttr", (String)fromDefinition.getQuery());
                    Assert.assertEquals((String)"urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", (String)fromDefinition.getQueryLanguage());
                    Assert.assertEquals((Object)Variant.VAR, (Object)toDefinition.getVariant());
                    Assert.assertEquals((String)"st1", (String)toDefinition.getVariable());
                    Assert.assertEquals((String)"tns:myElement/@myElementAttr/to", (String)toDefinition.getQuery());
                    Assert.assertEquals((String)"urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0:to", (String)toDefinition.getQueryLanguage());
                }
            }
        } else if ("assign05".equals(assignActivityFullDefinition.getName())) {
            Assert.assertEquals((boolean)false, (boolean)assignActivityFullDefinition.isValidate());
            while (copyDefinitionIterator.hasNext()) {
                CopyDefinition copyDefinition = (CopyDefinition)copyDefinitionIterator.next();
                List fromDefinitionList = copyDefinition.getFromDefinitionList();
                List toDefinitionList = copyDefinition.getToDefinitionList();
                Iterator fromDefinitionIterator = fromDefinitionList.iterator();
                Iterator toDefinitionIterator = toDefinitionList.iterator();
                while (fromDefinitionIterator.hasNext()) {
                    FromDefinition fromDefinition = (FromDefinition)fromDefinitionIterator.next();
                    ToDefinition toDefinition = (ToDefinition)toDefinitionIterator.next();
                    Assert.assertEquals((Object)Variant.PLNK, (Object)fromDefinition.getVariant());
                    Assert.assertEquals((String)"definitiontest01PL", (String)fromDefinition.getPartnerLink());
                    Assert.assertEquals((String)"myRole", (String)fromDefinition.getEndpointReference());
                    Assert.assertEquals((Object)Variant.PLNK, (Object)toDefinition.getVariant());
                    Assert.assertEquals((String)"definitiontest02PL", (String)toDefinition.getPartnerLink());
                    Assert.assertEquals(null, (String)toDefinition.getEndpointReference());
                }
            }
        } else if ("assign06".equals(assignActivityFullDefinition.getName())) {
            Assert.assertEquals((boolean)false, (boolean)assignActivityFullDefinition.isValidate());
            while (copyDefinitionIterator.hasNext()) {
                CopyDefinition copyDefinition = (CopyDefinition)copyDefinitionIterator.next();
                List fromDefinitionList = copyDefinition.getFromDefinitionList();
                List toDefinitionList = copyDefinition.getToDefinitionList();
                Iterator fromDefinitionIterator = fromDefinitionList.iterator();
                Iterator toDefinitionIterator = toDefinitionList.iterator();
                while (fromDefinitionIterator.hasNext()) {
                    FromDefinition fromDefinition = (FromDefinition)fromDefinitionIterator.next();
                    ToDefinition toDefinition = (ToDefinition)toDefinitionIterator.next();
                    Assert.assertEquals((Object)Variant.PROP, (Object)fromDefinition.getVariant());
                    Assert.assertEquals((String)"var1", (String)fromDefinition.getVariable());
                    Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}definitiontestPT", (String)fromDefinition.getProperty().toString());
                    Assert.assertEquals((Object)Variant.PROP, (Object)toDefinition.getVariant());
                    Assert.assertEquals((String)"var0", (String)toDefinition.getVariable());
                    Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}definitiontest02PT", (String)toDefinition.getProperty().toString());
                }
            }
        } else if (!"unused".equals(assignActivityFullDefinition.getName())) {
            Assert.fail((String)("Incorrect assign activity name: " + assignActivityFullDefinition.getName()));
        }
    }

    public void checkWaitActivity(BpelActivityFullDefinition activityFullDefinition) {
        WaitActivityFullDefinition waitActivityFullDefinition = (WaitActivityFullDefinition)activityFullDefinition.fullCopy();
        if ("wait01".equals(waitActivityFullDefinition.getName())) {
            ForDefinition forDefinition = waitActivityFullDefinition.getForDefinition();
            Assert.assertEquals((String)"'PT1S'", (String)forDefinition.getDurationExpression());
            Assert.assertEquals((String)"wait01ExpressionLanguage", (String)forDefinition.getExpressionLanguage());
        } else if ("wait02".equals(waitActivityFullDefinition.getName())) {
            UntilDefinition untilDefinition = waitActivityFullDefinition.getUntilDefinition();
            Assert.assertEquals((String)"demain", (String)untilDefinition.getDeadlineExpression());
            Assert.assertEquals((String)"wait02ExpressionLanguage", (String)untilDefinition.getExpressionLanguage());
        } else {
            Assert.fail((String)("Incorrect wait activity name: " + waitActivityFullDefinition.getName()));
        }
    }

    private void checkInvokeActivity(BpelActivityFullDefinition activityFullDefinition) {
        InvokeActivityFullDefinition invokeActivityFullDefinition = (InvokeActivityFullDefinition)activityFullDefinition.fullCopy();
        String name = invokeActivityFullDefinition.getName();
        if (name.equals("invokeToTest1")) {
            Assert.assertEquals((String)"suffix", (String)invokeActivityFullDefinition.getOperation());
            Assert.assertEquals((String)"stringWSRequest", (String)invokeActivityFullDefinition.getInputVariable());
            List fromPartDefinitions = invokeActivityFullDefinition.getFromPartDefinitions();
            Assert.assertEquals((int)1, (int)fromPartDefinitions.size());
            FromPartDefinition fromPartDefinition = (FromPartDefinition)fromPartDefinitions.get(0);
            Assert.assertEquals((String)"var1", (String)fromPartDefinition.getToVariable());
            Assert.assertEquals((String)"vlan", (String)fromPartDefinition.getPart());
        } else if (name.equals("invokeToTest2")) {
            Assert.assertEquals((String)"suffix", (String)invokeActivityFullDefinition.getOperation());
            Assert.assertEquals((String)"stringWSResponse", (String)invokeActivityFullDefinition.getOutputVariable());
            List toPartDefinitions = invokeActivityFullDefinition.getToPartDefinitions();
            Assert.assertEquals((int)1, (int)toPartDefinitions.size());
            ToPartDefinition toPartDefinition = (ToPartDefinition)toPartDefinitions.get(0);
            Assert.assertEquals((String)"var1", (String)toPartDefinition.getFromVariable());
            Assert.assertEquals((String)"vloum", (String)toPartDefinition.getPart());
        } else {
            Misc.unreachableStatement((String)"unknown invoke activity");
        }
    }

    private void checkWhileActivity(BpelActivityFullDefinition activityFullDefinition) {
        WhileActivityFullDefinition whileActivityFullDefinition = (WhileActivityFullDefinition)activityFullDefinition.fullCopy();
        String name = whileActivityFullDefinition.getName();
        if (name.equals("whileToTest")) {
            Assert.assertEquals((String)"var1 = 3", (String)whileActivityFullDefinition.getConditionBooleanExpression());
            Assert.assertEquals((String)"ocaml", (String)whileActivityFullDefinition.getConditionExpressionLanguage());
        } else {
            Misc.unreachableStatement((String)"unknown while activity");
        }
    }

    private void checkRepeatUntilActivity(BpelActivityFullDefinition activityFullDefinition) {
        RepeatUntilActivityFullDefinition repeatUntilActivityFullDefinition = (RepeatUntilActivityFullDefinition)activityFullDefinition.fullCopy();
        String name = repeatUntilActivityFullDefinition.getName();
        if (name.equals("repeatUntilToTest")) {
            Assert.assertEquals((String)"var1 = 3", (String)repeatUntilActivityFullDefinition.getConditionBooleanExpression());
            Assert.assertEquals((String)"ocaml", (String)repeatUntilActivityFullDefinition.getConditionExpressionLanguage());
        } else {
            Misc.unreachableStatement((String)"unknown while activity");
        }
    }

    private void checkIfActivity(BpelActivityFullDefinition activityFullDefinition) {
        IfActivityFullDefinition ifActivityFullDefinition = (IfActivityFullDefinition)activityFullDefinition.fullCopy();
        Assert.assertEquals((String)"1=1", (String)ifActivityFullDefinition.getExpression());
        Assert.assertEquals((String)"if01ExpressionLanguage01", (String)ifActivityFullDefinition.getExpressionLanguage());
        List elseIfDefinitionList = ifActivityFullDefinition.getElseIfDefinitionList();
        ElseFullDefinition elseDefinition = ifActivityFullDefinition.getElseDefinition();
        Assert.assertNotNull((Object)elseDefinition.getActivityDefinitionUUID());
        Iterator elseIfDefinitionIterator = elseIfDefinitionList.iterator();
        int id = 2;
        while (elseIfDefinitionIterator.hasNext()) {
            ElseIfFullDefinition elseIfDefinition = (ElseIfFullDefinition)elseIfDefinitionIterator.next();
            Assert.assertEquals((String)("if01Empty0" + id), (String)elseIfDefinition.getActivityDefinition().getName());
            Assert.assertNotNull((Object)elseIfDefinition.getActivityDefinitionUUID());
            Assert.assertEquals((String)(id + "=" + id), (String)elseIfDefinition.getExpression());
            Assert.assertEquals((String)("if01ExpressionLanguage0" + id), (String)elseIfDefinition.getExpressionLanguage());
            ++id;
        }
        Assert.assertEquals((int)(id - 2), (int)elseIfDefinitionList.size());
    }

    private void checkPickActivity(BpelActivityFullDefinition activityFullDefinition) {
        PickActivityFullDefinition pickActivityFullDefinition = (PickActivityFullDefinition)activityFullDefinition.fullCopy();
        if ("pick01".equals(pickActivityFullDefinition.getName())) {
            List onMessageFullDefinitionList = pickActivityFullDefinition.getOnMessageDefinitionList();
            Iterator onMessageFullDefinitionIterator = onMessageFullDefinitionList.iterator();
            int id = 1;
            while (onMessageFullDefinitionIterator.hasNext()) {
                OnMessageFullDefinition onMessageFullDefinition = (OnMessageFullDefinition)onMessageFullDefinitionIterator.next();
                Assert.assertEquals((String)("pick01Op0" + id), (String)onMessageFullDefinition.getOperation());
                Assert.assertEquals((String)"definitiontest01PL", (String)onMessageFullDefinition.getPartnerLink());
                Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}definitiontestPT", (String)onMessageFullDefinition.getPortType().toString());
                Assert.assertEquals((String)("pick01Empty0" + id), (String)onMessageFullDefinition.getActivityFullDefinition().getName());
                for (FromPartDefinition fromPartDefinition : onMessageFullDefinition.getFromPartDefinitionList()) {
                    Assert.assertEquals((String)("product0" + id), (String)fromPartDefinition.getPart());
                    Assert.assertEquals((String)"requestFromPart", (String)fromPartDefinition.getToVariable());
                }
                Assert.assertEquals(null, (String)onMessageFullDefinition.getMessageExchange());
                Assert.assertEquals(null, (String)onMessageFullDefinition.getVariable());
                Assert.assertEquals((String)"[]", (String)onMessageFullDefinition.getCorrelationDefinitionList().toString());
                ++id;
            }
            Assert.assertEquals((int)(id - 1), (int)onMessageFullDefinitionList.size());
        } else if ("pick02".equals(pickActivityFullDefinition.getName())) {
            List onMessageFullDefinitionList = pickActivityFullDefinition.getOnMessageDefinitionList();
            Iterator onMessageFullDefinitionIterator = onMessageFullDefinitionList.iterator();
            int id = 1;
            while (onMessageFullDefinitionIterator.hasNext()) {
                OnMessageFullDefinition onMessageFullDefinition = (OnMessageFullDefinition)onMessageFullDefinitionIterator.next();
                Assert.assertEquals((String)("pick02Op0" + id), (String)onMessageFullDefinition.getOperation());
                Assert.assertEquals((String)"definitiontest01PL", (String)onMessageFullDefinition.getPartnerLink());
                Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}definitiontestPT", (String)onMessageFullDefinition.getPortType().toString());
                Assert.assertEquals((String)("pick02Empty0" + id), (String)onMessageFullDefinition.getActivityFullDefinition().getName());
                Assert.assertEquals((String)"message01", (String)onMessageFullDefinition.getMessageExchange());
                Assert.assertEquals((String)"request", (String)onMessageFullDefinition.getVariable());
                Iterator correlationDefinitionIterator = onMessageFullDefinition.getCorrelationDefinitionList().iterator();
                CorrelationDefinition correlationDefinition = (CorrelationDefinition)correlationDefinitionIterator.next();
                Assert.assertEquals((String)"yes", (String)correlationDefinition.getInitiate());
                Assert.assertEquals((String)"auctionCS", (String)correlationDefinition.getSet());
                Assert.assertEquals((String)"[]", (String)onMessageFullDefinition.getFromPartDefinitionList().toString());
                ++id;
            }
            Assert.assertEquals((int)(id - 1), (int)onMessageFullDefinitionList.size());
        } else if ("pick03".equals(pickActivityFullDefinition.getName())) {
            List onMessageFullDefinitionList = pickActivityFullDefinition.getOnMessageDefinitionList();
            List onAlarmFullDefinitionList = pickActivityFullDefinition.getOnAlarmDefinitionList();
            Iterator onMessageFullDefinitionIterator = onMessageFullDefinitionList.iterator();
            int id = 1;
            while (onMessageFullDefinitionIterator.hasNext()) {
                OnMessageFullDefinition onMessageFullDefinition = (OnMessageFullDefinition)onMessageFullDefinitionIterator.next();
                Assert.assertEquals((String)("pick03Op0" + id), (String)onMessageFullDefinition.getOperation());
                Assert.assertEquals((String)"definitiontest01PL", (String)onMessageFullDefinition.getPartnerLink());
                Assert.assertEquals((String)"{http://orchestra.ow2.org/definitiontest}definitiontestPT", (String)onMessageFullDefinition.getPortType().toString());
                Assert.assertEquals((String)("pick03Empty0" + id), (String)onMessageFullDefinition.getActivityFullDefinition().getName());
                for (FromPartDefinition fromPartDefinition : onMessageFullDefinition.getFromPartDefinitionList()) {
                    Assert.assertEquals((String)("product0" + id), (String)fromPartDefinition.getPart());
                    Assert.assertEquals((String)"requestFromPart", (String)fromPartDefinition.getToVariable());
                }
                Assert.assertEquals(null, (String)onMessageFullDefinition.getMessageExchange());
                Assert.assertEquals(null, (String)onMessageFullDefinition.getVariable());
                Assert.assertEquals((String)"[]", (String)onMessageFullDefinition.getCorrelationDefinitionList().toString());
                ++id;
            }
            Assert.assertEquals((int)(id - 1), (int)onMessageFullDefinitionList.size());
            for (OnAlarmFullDefinition onAlarmFullDefinition : onAlarmFullDefinitionList) {
                if (onAlarmFullDefinition.getForDefinition() != null) {
                    Assert.assertEquals((String)"'PT1S'", (String)onAlarmFullDefinition.getForDefinition().getDurationExpression());
                    Assert.assertEquals((String)"pick03ExpressionLanguageFor", (String)onAlarmFullDefinition.getForDefinition().getExpressionLanguage());
                    Assert.assertEquals((String)"pick03Empty02", (String)onAlarmFullDefinition.getActivityFullDefinition().getName());
                }
                if (onAlarmFullDefinition.getUntilDefinition() == null) continue;
                Assert.assertEquals((String)"demainMatin", (String)onAlarmFullDefinition.getUntilDefinition().getDeadlineExpression());
                Assert.assertEquals((String)"pick03ExpressionLanguageUntil", (String)onAlarmFullDefinition.getUntilDefinition().getExpressionLanguage());
                Assert.assertEquals((String)"pick03Empty03", (String)onAlarmFullDefinition.getActivityFullDefinition().getName());
            }
        } else {
            Assert.fail((String)("Unknown pick activity: " + pickActivityFullDefinition.getName() + " - " + pickActivityFullDefinition.getUUID()));
        }
    }

    private void checkForeachActivity(BpelActivityFullDefinition activityFullDefinition) {
        ForeachActivityFullDefinition foreachActivityFullDefinition = (ForeachActivityFullDefinition)activityFullDefinition.fullCopy();
        if ("foreach01".equals(foreachActivityFullDefinition.getName())) {
            Assert.assertEquals((String)"var1", (String)foreachActivityFullDefinition.getCounterName());
            Assert.assertEquals((String)"10", (String)foreachActivityFullDefinition.getFinalCounterExpression());
            Assert.assertEquals((String)"foreach01ExpressionLanguageFinal", (String)foreachActivityFullDefinition.getFinalCounterExpressionLanguage());
            Assert.assertEquals((String)"5", (String)foreachActivityFullDefinition.getStartCounterExpression());
            Assert.assertEquals((String)"foreach01ExpressionLanguageStart", (String)foreachActivityFullDefinition.getStartCounterExpressionLanguage());
            Assert.assertEquals((boolean)true, (boolean)foreachActivityFullDefinition.isParallel());
        } else if ("foreach02".equals(foreachActivityFullDefinition.getName())) {
            Assert.assertEquals((String)"8+2=10", (String)foreachActivityFullDefinition.getCompletionConditionDefinition().getExpression());
            Assert.assertEquals((String)"foreach02ExpressionLanguageBranches", (String)foreachActivityFullDefinition.getCompletionConditionDefinition().getExpressionLanguage());
            Assert.assertEquals((boolean)true, (boolean)foreachActivityFullDefinition.getCompletionConditionDefinition().isSuccessfulBranchesOnly());
            Assert.assertEquals((String)"var1", (String)foreachActivityFullDefinition.getCounterName());
            Assert.assertEquals((String)"14", (String)foreachActivityFullDefinition.getFinalCounterExpression());
            Assert.assertEquals((String)"foreach02ExpressionLanguageFinal", (String)foreachActivityFullDefinition.getFinalCounterExpressionLanguage());
            Assert.assertEquals((String)"7", (String)foreachActivityFullDefinition.getStartCounterExpression());
            Assert.assertEquals((String)"foreach02ExpressionLanguageStart", (String)foreachActivityFullDefinition.getStartCounterExpressionLanguage());
            Assert.assertEquals((boolean)false, (boolean)foreachActivityFullDefinition.isParallel());
        } else {
            Assert.fail((String)("Unknown foreach activity: " + foreachActivityFullDefinition.getName() + " - " + foreachActivityFullDefinition.getUUID()));
        }
    }

    private void checkFlowActivity(BpelActivityFullDefinition activityFullDefinition) {
        FlowActivityFullDefinition flowActivityFullDefinition = (FlowActivityFullDefinition)activityFullDefinition.fullCopy();
        if ("flow01".equals(flowActivityFullDefinition.getName())) {
            List activityFullDefinitionList = flowActivityFullDefinition.getEnclosedActivities();
            List linkList = flowActivityFullDefinition.getLinks();
            Iterator activityFullDefinitionIterator = activityFullDefinitionList.iterator();
            Iterator linkIterator = linkList.iterator();
            int id = 1;
            while (linkIterator.hasNext()) {
                String link = (String)linkIterator.next();
                BpelActivityFullDefinition enclosedActivityFullDefinition = (BpelActivityFullDefinition)activityFullDefinitionIterator.next();
                SourceFull sourceFull = (SourceFull)enclosedActivityFullDefinition.getSourceList().iterator().next();
                Assert.assertEquals((String)("flow01Link0" + id), (String)link);
                Assert.assertEquals((String)("flow01Empty0" + id), (String)enclosedActivityFullDefinition.getName());
                Assert.assertEquals((String)("flow01Link0" + id), (String)sourceFull.getLinkName());
                Assert.assertEquals((String)("2+2=" + id), (String)sourceFull.getTransitionConditionBooleanExpression());
                Assert.assertEquals((String)("flow01Link0" + id + "TransitionConditionExpressionLanguage"), (String)sourceFull.getTransitionConditionExpressionLanguage());
                ++id;
            }
            Assert.assertEquals((int)(id - 1), (int)linkList.size());
            BpelActivityFullDefinition enclosedActivityFullDefinition = (BpelActivityFullDefinition)activityFullDefinitionIterator.next();
            List targetFullList = enclosedActivityFullDefinition.getTargetList();
            Iterator targetFullIterator = targetFullList.iterator();
            id = 1;
            while (targetFullIterator.hasNext()) {
                TargetFull targetFull = (TargetFull)targetFullIterator.next();
                Assert.assertEquals((String)("flow01Link0" + id), (String)targetFull.getLinkName());
                Assert.assertEquals((String)"1+1=2", (String)enclosedActivityFullDefinition.getTargetsJoinConditionBooleanExpression());
                Assert.assertEquals((String)"flow01TargetExpressionLanguage", (String)enclosedActivityFullDefinition.getTargetsJoinConditionExpressionLanguage());
                ++id;
            }
            Assert.assertEquals((int)(id - 1), (int)targetFullList.size());
        } else {
            Assert.fail((String)("Unknown activity: " + flowActivityFullDefinition.getName() + " - " + flowActivityFullDefinition.getUUID()));
        }
    }

    private void checkThrowActivity(BpelActivityFullDefinition activityFullDefinition) {
        ThrowActivityFullDefinition throwActivityFullDefinition = (ThrowActivityFullDefinition)activityFullDefinition.fullCopy();
        if ("throw1".equals(throwActivityFullDefinition.getName())) {
            Assert.assertNotNull((Object)throwActivityFullDefinition.getFaultName());
            Assert.assertEquals((String)"faultName1", (String)throwActivityFullDefinition.getFaultName().getLocalPart());
            Assert.assertEquals((String)"faultVariable1", (String)throwActivityFullDefinition.getFaultVariable());
        } else {
            Assert.fail((String)("Unknown activity: " + throwActivityFullDefinition.getName() + " - " + throwActivityFullDefinition.getUUID()));
        }
    }
}

