/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.example.weather;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WeatherTest
extends RemoteTestCase {
    public void testWeather() {
        try {
            String processName = "weather";
            String processNamespace = "http://orchestra.ow2.org/weather";
            QName processQName = new QName("http://orchestra.ow2.org/weather", "weather");
            this.deploy(((Object)((Object)this)).getClass().getResource("weather.bpel"), ((Object)((Object)this)).getClass().getResource("weatherArtifacts.wsdl"));
            String endpoint = this.getDefaultEndpoint("weatherPT");
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/weatherArtifacts/process", (String)"<weatherRequest xmlns='http://orchestra.ow2.org/weather'><input>Grenoble,France</input></weatherRequest>");
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)"weatherResponse", (String)result.getLocalName());
                Assert.assertEquals((String)"http://orchestra.ow2.org/weather", (String)result.getNamespaceURI());
                List children = XmlUtil.elements((Element)result);
                Assert.assertEquals((int)1, (int)children.size());
                Assert.assertEquals((String)"result", (String)((Element)children.get(0)).getLocalName());
                Assert.assertEquals((String)"http://orchestra.ow2.org/weather", (String)((Element)children.get(0)).getNamespaceURI());
                List<Text> texts = BpelTestCase.getTexts((Node)children.get(0));
                Assert.assertEquals((int)1, (int)texts.size());
                String s = texts.get(0).getData();
                Document doc = XmlUtil.getDocumentFromString((String)s);
                Assert.assertNotNull((Object)doc);
                Element rootElement = doc.getDocumentElement();
                Assert.assertNotNull((Object)rootElement);
                Assert.assertEquals((String)"CurrentWeather", (String)rootElement.getTagName());
                List elements = XmlUtil.elements((Element)rootElement);
                Assert.assertTrue((elements.size() >= 8 ? 1 : 0) != 0);
                Element location = (Element)rootElement.getElementsByTagName("Location").item(0);
                Assert.assertEquals((String)"Grenoble / St. Geoirs, France (LFLS) 45-22N 005-20E 386M", (String)location.getTextContent());
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            this.undeploy(processQName);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }
}

