/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.ow2.orchestra.pvm.internal.model.CompositeElementImpl;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.ObservableElementImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessDefinitionImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessElementImpl;
import org.ow2.orchestra.pvm.internal.model.TransitionImpl;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.FlowRuntime;
import org.ow2.orchestra.runtime.ForEachRuntime;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.test.runtime.RuntimeTestCase;

public class TestBpelExecution
extends RuntimeTestCase {
    private ProcessDefinitionImpl processDefinitionImpl;
    private NodeImpl nodeImpl;
    private TransitionImpl transitionImpl;
    private BpelExecution bpelExecution;

    public void testForEachRuntimePersistence() throws Exception {
        this.verifyPersistence(ForEachRuntime.class);
    }

    public void testScopeRuntimePersistence() throws Exception {
        this.verifyPersistence(ScopeRuntime.class);
    }

    public void testFlowRuntimePersistence() throws Exception {
        this.verifyPersistence(FlowRuntime.class);
    }

    public void testBpelExecutionPersistence() throws Exception {
        this.verifyPersistence(BpelExecution.class);
    }

    public boolean shouldExclude(String className, String fieldName) {
        if (className.equals(ExecutionImpl.class.getName())) {
            if (Arrays.asList("processDefinition", "node", "previousNode", "transition", "transitionOrigin", "previousTransition", "parent", "processInstance", "hasVariables", "variables").contains(fieldName)) {
                return true;
            }
            if (Arrays.asList("superProcessExecution", "event", "eventSource", "subProcessInstance", "exception", "processModifications", "propagation", "comments", "atomicOperations").contains(fieldName)) {
                return true;
            }
        }
        if (className.equals(BpelExecution.class.getName()) && Arrays.asList("forEachRuntime", "scopeRuntime", "flowRuntime").contains(fieldName)) {
            return true;
        }
        if (className.equals(ScopeRuntime.class.getName()) && Arrays.asList("scopeDefinition", "catchHasAlreadyBeenMatched", "compensateExecution").contains(fieldName)) {
            return true;
        }
        if (Arrays.asList(NodeImpl.class.getName(), CompositeElementImpl.class.getName(), ObservableElementImpl.class.getName(), ProcessElementImpl.class.getName()).contains(className)) {
            return true;
        }
        return super.shouldExclude(className, fieldName);
    }

    public Object createCustomReference(String className, String fieldName) {
        if (className.equals(ExecutionImpl.class.getName())) {
            if (fieldName.equals("processDefinition")) {
                return this.processDefinitionImpl;
            }
            if (Arrays.asList("node", "previousNode").contains(fieldName)) {
                return this.nodeImpl;
            }
            if (Arrays.asList("transition", "transitionOrigin", "previousTransition").contains(fieldName)) {
                return this.transitionImpl;
            }
            if (Arrays.asList("parent", "processInstance").contains(fieldName)) {
                return this.bpelExecution;
            }
            if (fieldName.equals("propagation")) {
                return ExecutionImpl.Propagation.EXPLICIT;
            }
            if (fieldName.equals("executions")) {
                return new ArrayList();
            }
            if (fieldName.equals("variables")) {
                return new HashMap();
            }
            if (fieldName.equals("jobs")) {
                return new ArrayList();
            }
        } else if (className.equals(BpelExecution.class.getName())) {
            if (fieldName.equals("repliers")) {
                return new HashSet();
            }
            if (fieldName.equals("waitingOperationKeys")) {
                return new HashSet();
            }
        } else if (className.equals(FlowRuntime.class.getName())) {
            if (fieldName.equals("linkRuntimes")) {
                return new HashMap();
            }
        } else if (className.equals(ScopeRuntime.class.getName())) {
            if (fieldName.equals("variables")) {
                return new HashMap();
            }
            if (fieldName.equals("partnerLinks")) {
                return new HashMap();
            }
            if (fieldName.equals("correlationSets")) {
                return new HashMap();
            }
            if (fieldName.equals("endedChildren")) {
                return new ArrayList();
            }
        }
        return null;
    }
}

