/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.objects;

import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.dtm.DTMManager;
import com.sun.org.apache.xml.internal.dtm.ref.DTMNodeIterator;
import com.sun.org.apache.xml.internal.dtm.ref.DTMNodeList;
import com.sun.org.apache.xml.internal.utils.FastStringBuffer;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import com.sun.org.apache.xml.internal.utils.XMLString;
import com.sun.org.apache.xpath.internal.NodeSetDTM;
import com.sun.org.apache.xpath.internal.axes.NodeSequence;
import com.sun.org.apache.xpath.internal.objects.Comparator;
import com.sun.org.apache.xpath.internal.objects.EqualComparator;
import com.sun.org.apache.xpath.internal.objects.GreaterThanComparator;
import com.sun.org.apache.xpath.internal.objects.GreaterThanOrEqualComparator;
import com.sun.org.apache.xpath.internal.objects.LessThanComparator;
import com.sun.org.apache.xpath.internal.objects.LessThanOrEqualComparator;
import com.sun.org.apache.xpath.internal.objects.NotEqualComparator;
import com.sun.org.apache.xpath.internal.objects.XObject;
import com.sun.org.apache.xpath.internal.objects.XString;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XNodeSet
extends NodeSequence {
    static final long serialVersionUID = 1916026368035639667L;
    static final LessThanComparator S_LT = new LessThanComparator();
    static final LessThanOrEqualComparator S_LTE = new LessThanOrEqualComparator();
    static final GreaterThanComparator S_GT = new GreaterThanComparator();
    static final GreaterThanOrEqualComparator S_GTE = new GreaterThanOrEqualComparator();
    static final EqualComparator S_EQ = new EqualComparator();
    static final NotEqualComparator S_NEQ = new NotEqualComparator();

    protected XNodeSet() {
    }

    public XNodeSet(DTMIterator val) {
        if (val instanceof XNodeSet) {
            this.setIter(((XNodeSet)val).m_iter);
            this.m_dtmMgr = ((XNodeSet)val).m_dtmMgr;
            this.m_last = ((XNodeSet)val).m_last;
            if (!((XNodeSet)val).hasCache()) {
                ((XNodeSet)val).setShouldCacheNodes(true);
            }
            this.m_obj = ((XNodeSet)val).m_obj;
        } else {
            this.setIter(val);
        }
    }

    public XNodeSet(XNodeSet val) {
        this.setIter(val.m_iter);
        this.m_dtmMgr = val.m_dtmMgr;
        this.m_last = val.m_last;
        if (!val.hasCache()) {
            val.setShouldCacheNodes(true);
        }
        this.m_obj = val.m_obj;
    }

    public XNodeSet(DTMManager dtmMgr) {
        this(-1, dtmMgr);
    }

    public XNodeSet(int n, DTMManager dtmMgr) {
        super(new NodeSetDTM(dtmMgr));
        this.m_dtmMgr = dtmMgr;
        if (-1 != n) {
            ((NodeSetDTM)this.m_obj).addNode(n);
            this.m_last = 1;
        } else {
            this.m_last = 0;
        }
    }

    public int getType() {
        return 4;
    }

    public String getTypeString() {
        return "#NODESET";
    }

    public double getNumberFromNode(int n) {
        XMLString xstr = this.m_dtmMgr.getDTM(n).getStringValue(n);
        return xstr.toDouble();
    }

    public double num() {
        int node = this.item(0);
        return node != -1 ? this.getNumberFromNode(node) : Double.NaN;
    }

    public double numWithSideEffects() {
        int node = this.nextNode();
        return node != -1 ? this.getNumberFromNode(node) : Double.NaN;
    }

    public boolean bool() {
        return this.item(0) != -1;
    }

    public boolean boolWithSideEffects() {
        return this.nextNode() != -1;
    }

    public XMLString getStringFromNode(int n) {
        if (-1 != n) {
            return this.m_dtmMgr.getDTM(n).getStringValue(n);
        }
        return XString.EMPTYSTRING;
    }

    public void dispatchCharactersEvents(ContentHandler ch) throws SAXException {
        int node = this.item(0);
        if (node != -1) {
            this.m_dtmMgr.getDTM(node).dispatchCharactersEvents(node, ch, false);
        }
    }

    public XMLString xstr() {
        int node = this.item(0);
        return node != -1 ? this.getStringFromNode(node) : XString.EMPTYSTRING;
    }

    public void appendToFsb(FastStringBuffer fsb) {
        XString xstring = (XString)this.xstr();
        xstring.appendToFsb(fsb);
    }

    public String str() {
        int node = this.item(0);
        return node != -1 ? ((Object)this.getStringFromNode(node)).toString() : "";
    }

    public Object object() {
        if (null == this.m_obj) {
            return this;
        }
        return this.m_obj;
    }

    public NodeIterator nodeset() throws TransformerException {
        return new DTMNodeIterator(this.iter());
    }

    public NodeList nodelist() throws TransformerException {
        DTMNodeList nodelist = new DTMNodeList(this);
        XNodeSet clone = (XNodeSet)nodelist.getDTMIterator();
        this.SetVector(clone.getVector());
        return nodelist;
    }

    public DTMIterator iterRaw() {
        return this;
    }

    public void release(DTMIterator iter) {
    }

    public DTMIterator iter() {
        try {
            if (this.hasCache()) {
                return this.cloneWithReset();
            }
            return this;
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse.getMessage());
        }
    }

    public XObject getFresh() {
        try {
            if (this.hasCache()) {
                return (XObject)((Object)this.cloneWithReset());
            }
            return this;
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse.getMessage());
        }
    }

    public NodeSetDTM mutableNodeset() {
        NodeSetDTM mnl;
        if (this.m_obj instanceof NodeSetDTM) {
            mnl = (NodeSetDTM)this.m_obj;
        } else {
            mnl = new NodeSetDTM(this.iter());
            this.m_obj = mnl;
            this.setCurrentPos(0);
        }
        return mnl;
    }

    public boolean compare(XObject obj2, Comparator comparator) throws TransformerException {
        boolean result = false;
        int type = obj2.getType();
        if (4 == type) {
            int node1;
            DTMIterator list1 = this.iterRaw();
            DTMIterator list2 = ((XNodeSet)obj2).iterRaw();
            Vector<XMLString> node2Strings = null;
            block0: while (-1 != (node1 = list1.nextNode())) {
                XMLString s1 = this.getStringFromNode(node1);
                if (null == node2Strings) {
                    int node2;
                    while (-1 != (node2 = list2.nextNode())) {
                        XMLString s2 = this.getStringFromNode(node2);
                        if (comparator.compareStrings(s1, s2)) {
                            result = true;
                            continue block0;
                        }
                        if (null == node2Strings) {
                            node2Strings = new Vector<XMLString>();
                        }
                        node2Strings.addElement(s2);
                    }
                    continue;
                }
                int n = node2Strings.size();
                for (int i = 0; i < n; ++i) {
                    if (!comparator.compareStrings(s1, (XMLString)node2Strings.elementAt(i))) continue;
                    result = true;
                    continue block0;
                }
            }
            list1.reset();
            list2.reset();
        } else if (1 == type) {
            double num1 = this.bool() ? 1.0 : 0.0;
            double num2 = obj2.num();
            result = comparator.compareNumbers(num1, num2);
        } else if (2 == type) {
            int node;
            DTMIterator list1 = this.iterRaw();
            double num2 = obj2.num();
            while (-1 != (node = list1.nextNode())) {
                double num1 = this.getNumberFromNode(node);
                if (!comparator.compareNumbers(num1, num2)) continue;
                result = true;
                break;
            }
            list1.reset();
        } else if (5 == type) {
            int node;
            XMLString s2 = obj2.xstr();
            DTMIterator list1 = this.iterRaw();
            while (-1 != (node = list1.nextNode())) {
                XMLString s1 = this.getStringFromNode(node);
                if (!comparator.compareStrings(s1, s2)) continue;
                result = true;
                break;
            }
            list1.reset();
        } else if (3 == type) {
            int node;
            XMLString s2 = obj2.xstr();
            DTMIterator list1 = this.iterRaw();
            while (-1 != (node = list1.nextNode())) {
                XMLString s1 = this.getStringFromNode(node);
                if (!comparator.compareStrings(s1, s2)) continue;
                result = true;
                break;
            }
            list1.reset();
        } else {
            result = comparator.compareNumbers(this.num(), obj2.num());
        }
        return result;
    }

    public boolean lessThan(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_LT);
    }

    public boolean lessThanOrEqual(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_LTE);
    }

    public boolean greaterThan(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_GT);
    }

    public boolean greaterThanOrEqual(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_GTE);
    }

    public boolean equals(XObject obj2) {
        try {
            return this.compare(obj2, S_EQ);
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
    }

    public boolean notEquals(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_NEQ);
    }
}

