/**
 * Copyright (C) 2010  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.cxf.example.loanApprovalCamel;

import org.apache.camel.builder.RouteBuilder;


/**
 * Route builder: defines the camel routes used by the process.
 *
 * @author Guillaume Porcher
 *
 */
public class LoanApprovalRouteBuilder extends RouteBuilder {


  @Override
  public void configure() throws Exception {
    // First route: from cxf endpoint to approval implementation
    this.from(
        "cxf://camel://direct:approval?"
        + "wsdlURL=approval.wsdl"
        + "&serviceClass=org.ow2.orchestra.cxf.example.loanApprovalCamel.ApprovalPT"
        + "&serviceName={http://orchestra.ow2.org/loanApproval/approval}approvalServiceBP"
        + "&portName={http://orchestra.ow2.org/loanApproval/approval}approvalPort")
        .bean(new ApprovalBindingImpl());

    // Second route: from direct endpoint to risk assessment implementation
    this.from("direct:risk").process(new RiskAssessmentBindingImpl());

  }

}
