/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.faultManagement.terminationHandler;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class TerminationHandlerForEachTest
extends BpelTestCase {
    public TerminationHandlerForEachTest() {
        super("http://orchestra.ow2.org/terminationHandlerForeach", "terminationHandlerForeach");
    }

    public void testTerminationHandlerForeach() {
        this.deploy();
        this.launch(1, 6, 3);
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch(final int start, final int stop, int branches) {
        int i;
        int callCount = Math.max(0, stop - start + 1);
        BpelTestCase.CallResult[] callResults = new BpelTestCase.CallResult[callCount];
        QName portTypeQName = new QName(this.getProcessNamespace(), "terminationHandlerForeachPT");
        String operationName = "start";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        parts.put("branches", BpelXmlUtil.createElementWithContent((String)Integer.toString(branches)));
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        operationName = "initiate";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(i)));
            parts.put("id", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i)));
            this.call(parts, portTypeQName, operationName);
        }
        operationName = "submit";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i - 1)));
            callResults[i] = this.call(parts, portTypeQName, operationName);
            if (i >= branches) continue;
            callResults[i].getMessageCarrier().getMessage();
        }
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){
            private static final long serialVersionUID = 1624305940767648609L;

            public Object execute(Environment environment) {
                MessageVariable reply = callResult.getMessageCarrier().getMessage();
                String count = reply.getPartValue("count").getTextContent();
                TerminationHandlerForEachTest.this.deleteInstance(callResult);
                String[] counts = count.split(",");
                Assert.assertEquals((String)"s", (String)counts[0]);
                boolean[] executions = new boolean[stop - start + 1];
                for (int i = 0; i < executions.length; ++i) {
                    executions[i] = false;
                }
                boolean gotS = false;
                block5: for (String s : counts) {
                    if ("s".equals(s)) {
                        if (gotS) {
                            Assert.fail((String)("got the start twice: " + count));
                        }
                        gotS = true;
                        continue;
                    }
                    switch (s.charAt(0)) {
                        case 'n': {
                            int n = Integer.parseInt(s.substring(1)) - start;
                            if (executions[n]) {
                                Assert.fail((String)("got the execution " + start + n + " twice in counts: " + count));
                            }
                            executions[n] = true;
                            continue block5;
                        }
                        case 't': {
                            int t = Integer.parseInt(s.substring(1)) - start;
                            if (executions[t]) {
                                Assert.fail((String)("got the execution " + start + t + " twice in counts: " + count));
                            }
                            executions[t] = true;
                            continue block5;
                        }
                        default: {
                            Assert.fail((String)("unknown part " + s + " in counts: " + count));
                        }
                    }
                }
                for (int i = 0; i < executions.length; ++i) {
                    if (executions[i]) continue;
                    Assert.fail((String)("branch " + start + i + " never executed in counts: " + count));
                }
                int expectedSize = executions.length + 1;
                Assert.assertEquals((String)("invalid counts " + count + " length"), (int)expectedSize, (int)counts.length);
                return null;
            }
        });
        return endTime;
    }
}

