/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.util;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BpelUtilTest
extends BpelTestCase {
    private final String firstPrefix = "ns1";
    private final String secondPrefix = "ns2";
    private final String elemTagName = "elem";
    private final String childTagName = "childElem";
    private Element firstRootElem;
    private Element secondRootElem;

    public BpelUtilTest() {
        super("http://example.com/bpelUtil", "BpelUtil");
    }

    public void testEqualsNodes() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        this.firstRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.firstPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.firstRootElem, this.firstPrefix, this.elemTagName, this.childTagName);
        this.secondRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.secondPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.secondRootElem, this.secondPrefix, this.elemTagName, this.childTagName);
        Assert.assertTrue((boolean)BpelUtil.areNodeEquals((Node)this.firstRootElem, (Node)this.secondRootElem));
        this.firstRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.firstPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.firstRootElem, this.firstPrefix, this.elemTagName, this.childTagName);
        this.secondRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.secondPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.secondRootElem, this.firstPrefix, this.elemTagName, this.childTagName);
        Assert.assertTrue((boolean)BpelUtil.areNodeEquals((Node)this.firstRootElem, (Node)this.secondRootElem));
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Assert.fail();
        }
        DocumentType docType1 = builder.getDOMImplementation().createDocumentType("qualifiedName", "publicId", "systemId");
        DocumentType docType2 = builder.getDOMImplementation().createDocumentType("qualifiedName", "publicId", "systemId");
        Assert.assertTrue((boolean)BpelUtil.areNodeEquals((Node)docType1, (Node)docType2));
    }

    public void testDiffNodeNamespace() {
        this.firstRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.firstPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.firstRootElem, this.firstPrefix, this.elemTagName, this.childTagName);
        this.secondRootElem = BpelXmlUtil.createElement((String)"http://otherNamespace", (String)(this.secondPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.secondRootElem, this.secondPrefix, this.elemTagName, this.childTagName);
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)this.firstRootElem, (Node)this.secondRootElem));
        this.firstRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.firstPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.firstRootElem, this.firstPrefix, this.elemTagName, this.childTagName);
        this.secondRootElem = BpelXmlUtil.createElement((String)"http://otherNamespace", (String)(this.firstPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.secondRootElem, this.firstPrefix, this.elemTagName, this.childTagName);
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)this.firstRootElem, (Node)this.secondRootElem));
    }

    public void testDiffNodeAttrValues() {
        this.firstRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.firstPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.firstRootElem, this.firstPrefix, this.elemTagName, this.childTagName);
        this.secondRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.secondPrefix + ":root-elem2"));
        this.addnewElementWithPrefix(this.secondRootElem, this.secondPrefix, this.elemTagName, this.childTagName);
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)this.firstRootElem, (Node)this.secondRootElem));
        this.firstRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.firstPrefix + ":root-elem"));
        this.firstRootElem.setAttribute("attr", "attrValue");
        this.addnewElementWithPrefix(this.firstRootElem, this.firstPrefix, this.elemTagName, this.childTagName);
        this.secondRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.secondPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.secondRootElem, this.secondPrefix, this.elemTagName, this.childTagName);
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)this.firstRootElem, (Node)this.secondRootElem));
        Document firstDoc = XmlUtil.getNewDocument();
        CDATASection firstNode = firstDoc.createCDATASection("Content");
        this.firstRootElem = firstDoc.createElementNS(this.getProcessNamespace(), this.firstPrefix + ":root-elem");
        firstDoc.appendChild(this.firstRootElem);
        this.firstRootElem.appendChild(firstNode);
        Document secondDoc = XmlUtil.getNewDocument();
        CDATASection secondNode = secondDoc.createCDATASection("Content2");
        this.secondRootElem = secondDoc.createElementNS(this.getProcessNamespace(), this.secondPrefix + ":root-elem");
        secondDoc.appendChild(this.secondRootElem);
        this.secondRootElem.appendChild(secondNode);
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)this.firstRootElem, (Node)this.secondRootElem));
    }

    public void testDiffNodeChilds() {
        this.firstRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.firstPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.firstRootElem, this.firstPrefix, this.elemTagName, this.childTagName);
        this.secondRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.secondPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.secondRootElem, this.secondPrefix, this.elemTagName, "childElem2");
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)this.firstRootElem, (Node)this.secondRootElem));
        this.firstRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.firstPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.firstRootElem, this.firstPrefix, this.elemTagName, this.childTagName);
        this.secondRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.secondPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.secondRootElem, this.secondPrefix, this.elemTagName, this.childTagName);
        this.addnewElementWithPrefix(this.secondRootElem, this.secondPrefix, this.elemTagName, this.childTagName);
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)this.firstRootElem, (Node)this.secondRootElem));
        this.firstRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.firstPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.firstRootElem, this.firstPrefix, this.elemTagName, this.childTagName);
        this.secondRootElem = BpelXmlUtil.createElement((String)this.getProcessNamespace(), (String)(this.secondPrefix + ":root-elem"));
        this.addnewElementWithPrefix(this.secondRootElem, this.secondPrefix, this.elemTagName, this.childTagName);
        this.addnewElementWithPrefix(this.secondRootElem.getFirstChild(), this.secondPrefix, "otherElementTag", "otherChildTag");
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)this.firstRootElem, (Node)this.secondRootElem));
    }

    public void testDiffDocTypeNode() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document doc1 = null;
        Document doc2 = null;
        Document doc3 = null;
        Document doc4 = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Assert.fail();
        }
        DocumentType docType1 = builder.getDOMImplementation().createDocumentType("qualifiedName", "publicId", "systemId");
        DocumentType docType2 = builder.getDOMImplementation().createDocumentType("qualifiedName", "publicId2", "systemId");
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)docType1, (Node)docType2));
        docType2 = builder.getDOMImplementation().createDocumentType("qualifiedName", "publicId", "systemId2");
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)docType1, (Node)docType2));
        try {
            doc1 = builder.parse(((Object)((Object)this)).getClass().getResource("reference/docType.xml").toString());
            doc2 = builder.parse(((Object)((Object)this)).getClass().getResource("entities/DTD2.0/entitiesDocType2.0.xml").toString());
            doc3 = builder.parse(((Object)((Object)this)).getClass().getResource("entities/DTD2.1/entitiesDocType2.1.xml").toString());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)doc1.getDoctype(), (Node)doc2.getDoctype()));
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)doc1.getDoctype(), (Node)doc3.getDoctype()));
        try {
            doc1 = builder.parse(((Object)((Object)this)).getClass().getResource("internalSubSetDocType1.xml").toString());
            doc2 = builder.parse(((Object)((Object)this)).getClass().getResource("internalSubSetDocType2.xml").toString());
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)doc1.getDoctype(), (Node)doc2.getDoctype()));
        try {
            doc1 = builder.parse(((Object)((Object)this)).getClass().getResource("reference/docType.xml").toString());
            doc2 = builder.parse(((Object)((Object)this)).getClass().getResource("notations/DTD2.0/notationsDocType2.0.xml").toString());
            doc3 = builder.parse(((Object)((Object)this)).getClass().getResource("notations/DTD2.1/notationsDocType2.1.xml").toString());
            doc4 = builder.parse(((Object)((Object)this)).getClass().getResource("notations/DTD2.2/notationsDocType2.2.xml").toString());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)doc1.getDoctype(), (Node)doc2.getDoctype()));
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)doc1.getDoctype(), (Node)doc3.getDoctype()));
        Assert.assertFalse((boolean)BpelUtil.areNodeEquals((Node)doc1.getDoctype(), (Node)doc4.getDoctype()));
    }

    private void addnewElementWithPrefix(Node parentNode, String prefix, String elemName, String childName) {
        Document document = parentNode.getOwnerDocument();
        Element elem = document.createElementNS(this.getProcessNamespace(), prefix + ":" + elemName);
        elem.setAttribute("firstAttr", "attributeValue1");
        elem.setAttribute("secondAttr", "attributeValue2");
        parentNode.appendChild(elem);
        Element child = document.createElementNS(this.getProcessNamespace(), prefix + ":" + childName);
        child.setTextContent("Child1 Content");
        elem.appendChild(child);
        child.setTextContent("Child2 Content");
        elem.appendChild(child);
    }
}

