package org.ow2.orchestra.cxf.example.loanApprovalCamel;

import java.math.BigInteger;

import org.apache.camel.Handler;

/**
 * Implementation of the Approval Web Service.
 *
 * Used in a route with a CXF endpoint. The CXF endpoint parses the SOAP message
 * and creates an object array with the web service parameters. The CXF endpoint creates
 * reply SOAP message from the string output.
 *
 * The method annotated with {@Handler} is called by Camel.
 *
 * @author Guillaume Porcher
 *
 */
public class ApprovalBindingImpl implements ApprovalPT {

  public java.lang.String approve(final java.lang.String firstName,
      final java.lang.String name, final BigInteger amount) {
    if ("Dupont".equals(name) || "McDonalds".equals(name)) {
      if (amount.intValue() < 30000) {
        return "yes";
      }
      return "no";
    } else if ("Kent".equals(name) || "Martin".equals(name)) {
      if (amount.intValue() < 10000) {
        return "yes";
      }
      return "no";
    } else if (amount.intValue() < 50000) {
      return "yes";
    }
    return "no";
  }

  @Handler
  public java.lang.String approve(final Object[] params) {
    return this.approve((String) params[0], (String) params[1], (BigInteger) params[2]);
  }
}
