/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.foreach;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class CompletionConditionForEachTest
extends BpelTestCase {
    public CompletionConditionForEachTest() {
        super("http://orchestra.ow2.org/foreach", "completionConditionForeach", BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testCompletionConditionForEach() {
        this.deploy();
        this.launch(1, 6, 3);
        this.undeploy();
    }

    public void testCompletionConditionForEachSuccessfulOnly() {
        this.deploy();
        this.launch(1, 6, -3);
        this.undeploy();
    }

    public void testGreaterCompletionConditionForEach() {
        this.deploy();
        BpelFaultException e = this.launchInvalid("1", "6", "8");
        Assert.assertNotNull((String)"InvalidBranchCondition expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidBranchCondition.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public void testVeryInvalidCompletionConditionForEach() {
        this.deploy();
        BpelFaultException e = this.launchInvalid("2", "6", "abc");
        Assert.assertNotNull((String)"invalidExpressionValue expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidExpressionValue.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public BpelFaultException launchInvalid(String start, String stop, String branches) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)start));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)stop));
        parts.put("branches", BpelXmlUtil.createElementWithContent((String)branches));
        QName portTypeQName = new QName(this.getProcessNamespace(), "foreachPT");
        String operationName = "submit";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        BpelFaultException exception = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), BpelFaultException.class);
        this.deleteInstances(1);
        return exception;
    }

    public long launch(final int start, final int stop, final int branches) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        parts.put("branches", BpelXmlUtil.createElementWithContent((String)Integer.toString(branches)));
        QName portTypeQName = new QName(this.getProcessNamespace(), "foreachPT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){
            private static final long serialVersionUID = 1624305940767648609L;

            public Object execute(Environment environment) {
                int expectedSize;
                MessageVariable reply = callResult.getMessageCarrier().getMessage();
                String[] counts = reply.getPartValue("count").getTextContent().split(",");
                Assert.assertTrue((boolean)counts[0].equals("s"));
                if (branches < 0) {
                    expectedSize = -branches * 2;
                    if (start % 2 != 0) {
                        --expectedSize;
                    }
                    expectedSize = Math.min(expectedSize, Math.max(0, stop - start + 1));
                } else {
                    expectedSize = branches;
                }
                Assert.assertEquals((int)(++expectedSize), (int)counts.length);
                for (int i = 1; i < expectedSize; ++i) {
                    Assert.assertEquals((int)(start + i - 1), (int)Integer.parseInt(counts[i]));
                }
                CompletionConditionForEachTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }
}

