/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.impl;

import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.services.handlers.impl.ArchiveFinishedInstanceHandler;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.TestInvoker;
import org.ow2.orchestra.test.TestValidatorImpl;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.w3c.dom.Element;

public class ArchiveFinishedInstanceHandlerTest
extends BpelTestCase {
    private static final int ACTIVITIES_BY_INSTANCE = 5;
    private int initialJournalRunnedCount;
    private int initialHistoryCount;

    public ArchiveFinishedInstanceHandlerTest() {
        super("http://orchestra.ow2.org/dfih", "archiveFIH", BpelTestCase.EnvironmentType.CUSTOM);
    }

    public void testArchiveFIH() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public DefaultEnvXMLGenerator getCustomEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.INTERNAL_JOURNAL_WITH_HISTORY);
        envGenerator.setInvokerType(TestInvoker.class);
        envGenerator.setApplicationEntry("testValidator", TestValidatorImpl.class);
        envGenerator.setFinishedInstanceHandlerType(new Class[]{ArchiveFinishedInstanceHandler.class});
        return envGenerator;
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource("archiveFIH.bpel"), ((Object)((Object)this)).getClass().getResource("dfih.wsdl"));
    }

    public void launch() {
        HashMap<String, Element> parts1 = new HashMap<String, Element>();
        parts1.put("inv", BpelXmlUtil.createElementWithContent((String)"1"));
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("inv", BpelXmlUtil.createElementWithContent((String)"2"));
        HashMap<String, Element> parts3 = new HashMap<String, Element>();
        parts3.put("inv", BpelXmlUtil.createElementWithContent((String)"3"));
        QName portTypeQName = new QName(this.getProcessNamespace(), "dfihPT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts1, portTypeQName, "submit");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = EnvTool.getJournalQueriers();
                ArchiveFinishedInstanceHandlerTest.this.initialJournalRunnedCount = querier.findProcessInstances(ActivityState.FINISHED).size();
                Set processFullInstanceSet = querier.findProcessInstances(ActivityState.RUNNING);
                Assert.assertEquals((int)1, (int)processFullInstanceSet.size());
                Querier history = EnvTool.getHistoryQueriers();
                processFullInstanceSet = history.findProcessInstances();
                ArchiveFinishedInstanceHandlerTest.this.initialHistoryCount = processFullInstanceSet.size();
                return null;
            }
        });
        final BpelTestCase.CallResult callResult2 = this.call(parts2, portTypeQName, "submit");
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = EnvTool.getJournalQueriers();
                ArchiveFinishedInstanceHandlerTest.this.initialJournalRunnedCount = querier.findProcessInstances(ActivityState.FINISHED).size();
                Set processFullInstanceSet = querier.findProcessInstances(ActivityState.RUNNING);
                Assert.assertEquals((int)2, (int)processFullInstanceSet.size());
                Querier history = EnvTool.getHistoryQueriers();
                processFullInstanceSet = history.findProcessInstances();
                Assert.assertEquals((int)ArchiveFinishedInstanceHandlerTest.this.initialHistoryCount, (int)processFullInstanceSet.size());
                return null;
            }
        });
        this.call(parts1, portTypeQName, "continue");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = EnvTool.getJournalQueriers();
                Set processFullInstanceSet = querier.findProcessInstances(ActivityState.RUNNING);
                Assert.assertEquals((int)1, (int)processFullInstanceSet.size());
                Querier history = EnvTool.getHistoryQueriers();
                processFullInstanceSet = history.findProcessInstances();
                Assert.assertEquals((int)(ArchiveFinishedInstanceHandlerTest.this.initialHistoryCount + 1), (int)processFullInstanceSet.size());
                return null;
            }
        });
        final BpelTestCase.CallResult callResult3 = this.call(parts3, portTypeQName, "submit");
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = EnvTool.getJournalQueriers();
                ArchiveFinishedInstanceHandlerTest.this.initialJournalRunnedCount = querier.findProcessInstances(ActivityState.FINISHED).size();
                Set processFullInstanceSet = querier.findProcessInstances(ActivityState.RUNNING);
                Assert.assertEquals((int)2, (int)processFullInstanceSet.size());
                Querier history = EnvTool.getHistoryQueriers();
                processFullInstanceSet = history.findProcessInstances();
                Assert.assertEquals((int)(ArchiveFinishedInstanceHandlerTest.this.initialHistoryCount + 1), (int)processFullInstanceSet.size());
                return null;
            }
        });
        this.call(parts2, portTypeQName, "continue");
        this.call(parts3, portTypeQName, "continue");
        this.waitForInstanceEnd(callResult2.getProcessInstanceUUID());
        this.waitForInstanceEnd(callResult3.getProcessInstanceUUID());
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                callResult.getMessageCarrier().getMessage();
                callResult2.getMessageCarrier().getMessage();
                callResult3.getMessageCarrier().getMessage();
                Querier querier = EnvTool.getJournalQueriers();
                Set processFullInstanceSet = querier.findProcessInstances(ActivityState.RUNNING);
                Assert.assertEquals((int)0, (int)processFullInstanceSet.size());
                Querier history = EnvTool.getHistoryQueriers();
                processFullInstanceSet = history.findProcessInstances();
                Assert.assertEquals((int)(ArchiveFinishedInstanceHandlerTest.this.initialHistoryCount + 3), (int)processFullInstanceSet.size());
                ArchiveFinishedInstanceHandlerTest.this.deleteInstance(callResult);
                ArchiveFinishedInstanceHandlerTest.this.deleteInstance(callResult2);
                ArchiveFinishedInstanceHandlerTest.this.deleteInstance(callResult3);
                return null;
            }
        });
    }
}

