/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.eventHandlers.onEvent;

import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class NestedOnAlarmTest
extends BpelTestCase {
    private final long time = 4L;

    public NestedOnAlarmTest() {
        super("http://orchestra.ow2.org/OnAlarmTest", "OnAlarmTest");
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public BpelTestCase.CallResult launch(String message) {
        return this.launch(message, this.time);
    }

    public BpelTestCase.CallResult launch(String message, long alarmTime) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("duration", BpelXmlUtil.createElementWithContent((String)("PT" + alarmTime + "S")));
        parts.put("message", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PortType");
        String operationName = "OnAlarmTestOperation";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "OnAlarmTestOperation");
        return callResult;
    }

    private void deleteInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                NestedOnAlarmTest.this.deleteInstance(callResult);
                return null;
            }
        });
    }

    public void testOnAlarmProcessVariableEvent() {
        this.deploy();
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        BpelTestCase.CallResult result = this.launch(message, 5L);
        this.launch(message, 3L);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod(result);
        this.undeploy();
    }

    public void testOnAlarmProcessVariableEvent2() {
        String message;
        this.deploy();
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        String expectedResponse = message = UUID.randomUUID().toString();
        BpelTestCase.CallResult result = this.launch(message, 5L);
        this.launch(message, 8L);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod(result);
        this.undeploy();
    }
}

