/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.invoke;

import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.PersonWS;
import org.ow2.orchestra.test.wsutils.StringWS;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class InvokeTest
extends BpelTestCase {
    public InvokeTest() {
        super("http://example.com/invoke", "invoke");
    }

    public void testInvoke() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        String suffix = "-response";
        String content = "invoke input";
        Element inputElement = XmlUtil.getDocumentWithOneElement((QName)new QName("http://example.com/invoke", "invoke"));
        Text textContent = inputElement.getOwnerDocument().createTextNode("invoke input");
        inputElement.appendChild(textContent);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("input", inputElement);
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "invoke";
        WSRepository.addWS(StringWS.PORTTYPE_QNAME, new StringWS("-response"));
        final BpelTestCase.CallResult result = this.call(parts, portTypeQName, "invoke");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        MessageVariable reply = result.getMessageCarrier().getMessage();
        Assert.assertNotNull((Object)reply);
        Element suffixElement = reply.getPartValue("output");
        Assert.assertEquals((String)"invokeResponse", (String)suffixElement.getLocalName());
        Assert.assertEquals((String)"http://example.com/invoke", (String)suffixElement.getNamespaceURI());
        Assert.assertTrue((String)"output part root element first child is not a text", (boolean)(suffixElement.getFirstChild() instanceof Text));
        Text text = (Text)suffixElement.getFirstChild();
        Assert.assertEquals((String)"invoke input-response", (String)text.getTextContent());
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                InvokeTest.this.deleteInstance(result);
                return null;
            }
        });
        WSRepository.removeWS(StringWS.PORTTYPE_QNAME);
        this.undeploy();
    }

    public void testInvokeBadPLNK() {
        try {
            this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "BadPLNK.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No partnerRole defined for partnerLink: stringWSPL"));
        }
    }

    public static void assertElement(Node n, String ns, String localName, String textContent) {
        Assert.assertNotNull((Object)n);
        Assert.assertTrue((boolean)(n instanceof Element));
        Element el = (Element)n;
        Assert.assertEquals((String)ns, (String)el.getNamespaceURI());
        Assert.assertEquals((String)localName, (String)el.getLocalName());
        Assert.assertEquals((int)1, (int)el.getChildNodes().getLength());
        Node child = el.getChildNodes().item(0);
        Assert.assertTrue((boolean)(child instanceof Text));
        Text text = (Text)child;
        Assert.assertEquals((String)textContent, (String)text.getTextContent());
    }

    public static void assertPerson(Node n, String firstName, String lastName, String age, String street, String zip, String city) {
        Assert.assertNotNull((Object)n);
        Assert.assertTrue((boolean)(n instanceof Element));
        Element el = (Element)n;
        String ns = PersonWS.PORTTYPE_QNAME.getNamespaceURI();
        Assert.assertEquals((String)ns, (String)el.getNamespaceURI());
        Assert.assertEquals((String)"person", (String)el.getLocalName());
        List children = XmlUtil.elements((Element)el);
        Assert.assertEquals((int)4, (int)children.size());
        InvokeTest.assertElement((Node)children.get(0), ns, "firstName", firstName);
        InvokeTest.assertElement((Node)children.get(1), ns, "lastName", lastName);
        InvokeTest.assertElement((Node)children.get(2), ns, "age", age);
        Assert.assertTrue((boolean)(children.get(3) instanceof Element));
        Element addressEl = (Element)children.get(3);
        List addressChildren = XmlUtil.elements((Element)addressEl);
        Assert.assertEquals((int)3, (int)addressChildren.size());
        InvokeTest.assertElement((Node)addressChildren.get(0), ns, "street", street);
        InvokeTest.assertElement((Node)addressChildren.get(1), ns, "zip", zip);
        InvokeTest.assertElement((Node)addressChildren.get(2), ns, "city", city);
    }
}

