/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.persistence.log.LoggerRecorder;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.services.RecordSteps;
import org.ow2.orchestra.test.services.TestRecorder;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class RecorderTest
extends BpelTestCase {
    public RecorderTest() {
        super("http://orchestra.ow2.org/loggerrecordertest", "loggerrecordertest", BpelTestCase.EnvironmentType.CUSTOM);
    }

    public void testRecorder() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public DefaultEnvXMLGenerator getCustomEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = BpelTestCase.getBpelTestEnvGenerator();
        envGenerator.setRecorderType(new Class[]{TestRecorder.class, LoggerRecorder.class});
        return envGenerator;
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        String falseParam = "bidon";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("function", BpelXmlUtil.createElementWithContent((String)"bidon"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        TestRecorder.initialiseResults();
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        CommandService commandServiceUpdate = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandServiceUpdate.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                callResult.getInstance().suspendInstance();
                callResult.getInstance().resumeInstance();
                return null;
            }
        });
        callResult.getMessageCarrier().getMessage();
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                TestRecorder testRecorder = (TestRecorder)environment.get(TestRecorder.class);
                ArrayList<RecordSteps> recordList = new ArrayList<RecordSteps>(testRecorder.getResults());
                List<ActivityInstanceUUID> activitiesStarted = testRecorder.getActivitiesUUIDStarted();
                List<ActivityInstanceUUID> activitiesEnded = testRecorder.getActivitiesUUIDEnded();
                ArrayList<String> mappingName = new ArrayList<String>();
                mappingName.add("recordInstanceStarted");
                mappingName.add("recordActivityStarted");
                mappingName.add("recordActivityStarted");
                mappingName.add("recordActivityEnded");
                mappingName.add("recordActivityStarted");
                mappingName.add("recordInstanceUpdated");
                mappingName.add("recordInstanceUpdated");
                mappingName.add("recordActivityEnded");
                mappingName.add("recordActivityStarted");
                mappingName.add("recordActivityStarted");
                mappingName.add("recordActivityStarted");
                mappingName.add("recordActivityEnded");
                mappingName.add("recordActivityEnded");
                mappingName.add("recordActivityStarted");
                mappingName.add("recordActivityStarted");
                mappingName.add("recordActivityEnded");
                mappingName.add("recordActivityEnded");
                mappingName.add("recordActivityStarted");
                mappingName.add("recordActivityStarted");
                mappingName.add("recordActivityEnded");
                mappingName.add("recordActivityEnded");
                mappingName.add("recordActivityEnded");
                mappingName.add("recordActivityStarted");
                mappingName.add("recordActivityEnded");
                mappingName.add("recordActivityEnded");
                mappingName.add("recordInstanceEnded");
                Assert.assertEquals((int)mappingName.size(), (int)recordList.size());
                Iterator recordListIteratorItem = recordList.iterator();
                Iterator mappingNameIteratorItem = mappingName.iterator();
                Iterator<ActivityInstanceUUID> activitiesEndedIterator = activitiesEnded.iterator();
                Iterator<ActivityInstanceUUID> activitiesStartedIterator = activitiesStarted.iterator();
                Stack<ActivityInstanceUUID> stack = new Stack<ActivityInstanceUUID>();
                int bypassFirstActivity = 0;
                while (recordListIteratorItem.hasNext()) {
                    RecordSteps recordStepsItem = (RecordSteps)recordListIteratorItem.next();
                    String mappingNameItem = (String)mappingNameIteratorItem.next();
                    Assert.assertEquals((String)recordStepsItem.getName(), (String)mappingNameItem);
                    if (recordStepsItem.getName().equals("recordActivityEnded")) {
                        Assert.assertNotNull((Object)recordStepsItem.getActivityInstanceUUID());
                        Assert.assertEquals(stack.pop(), (Object)activitiesEndedIterator.next());
                        continue;
                    }
                    if (recordStepsItem.getName().equals("recordExceptionOccured")) {
                        Assert.assertNotNull((Object)recordStepsItem.getActivityInstanceUUID());
                        Assert.assertEquals(stack.pop(), (Object)activitiesEndedIterator.next());
                        continue;
                    }
                    if (recordStepsItem.getName().equals("recordActivityStarted")) {
                        Assert.assertNotNull((Object)recordStepsItem.getActivityInstanceUUID());
                        Assert.assertNotNull((Object)recordStepsItem.getInstanceUUID());
                        Assert.assertNotNull((Object)recordStepsItem.getProcessUUID());
                        if (bypassFirstActivity != 0) {
                            Assert.assertNotNull((Object)recordStepsItem.getEncloserInstanceUUID());
                            Assert.assertEquals(stack.peek(), (Object)recordStepsItem.getEncloserInstanceUUID());
                        }
                        stack.push(activitiesStartedIterator.next());
                        ++bypassFirstActivity;
                        continue;
                    }
                    if (recordStepsItem.getName().equals("recordInstanceStarted")) {
                        Assert.assertNotNull((Object)recordStepsItem.getProcessUUID());
                        Assert.assertNotNull((Object)recordStepsItem.getInstanceUUID());
                        continue;
                    }
                    if (recordStepsItem.getName().equals("recordInstanceUpdated")) {
                        Assert.assertNotNull((Object)recordStepsItem.getProcessUUID());
                        Assert.assertNotNull((Object)recordStepsItem.getInstanceUUID());
                        continue;
                    }
                    if (!recordStepsItem.getName().equals("recordInstanceEnded")) continue;
                    Assert.assertNotNull((Object)recordStepsItem.getInstanceUUID());
                }
                RecorderTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }
}

