/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.impl;

import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.services.handlers.impl.DeleteFinishedInstanceHandler;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.services.runtime.JournalTest;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.w3c.dom.Element;

public class DeleteFinishedInstanceHandlerTest
extends BpelTestCase {
    private int size;

    public DeleteFinishedInstanceHandlerTest() {
        super("http://orchestra.ow2.org/dfih", "dfih", BpelTestCase.EnvironmentType.CUSTOM);
    }

    public void testDFIH() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public DefaultEnvXMLGenerator getCustomEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = JournalTest.getJournalEnvGenerator();
        envGenerator.setFinishedInstanceHandlerType(new Class[]{DeleteFinishedInstanceHandler.class});
        return envGenerator;
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource("dfih.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public void launch() {
        HashMap<String, Element> parts1 = new HashMap<String, Element>();
        parts1.put("inv", BpelXmlUtil.createElementWithContent((String)"1"));
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("inv", BpelXmlUtil.createElementWithContent((String)"2"));
        HashMap<String, Element> parts3 = new HashMap<String, Element>();
        parts3.put("inv", BpelXmlUtil.createElementWithContent((String)"3"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Repository repository = EnvTool.getRepository();
                List bpelExecList = repository.getInstances();
                DeleteFinishedInstanceHandlerTest.this.size = bpelExecList.size();
                return null;
            }
        });
        final BpelTestCase.CallResult callResult = this.call(parts1, portTypeQName, "submit");
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Repository repository = EnvTool.getRepository();
                List bpelExecList = repository.getInstances();
                Assert.assertEquals((int)(DeleteFinishedInstanceHandlerTest.this.size + 1), (int)bpelExecList.size());
                return null;
            }
        });
        final BpelTestCase.CallResult callResult2 = this.call(parts2, portTypeQName, "submit");
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Repository repository = EnvTool.getRepository();
                List bpelExecList = repository.getInstances();
                Assert.assertEquals((int)(DeleteFinishedInstanceHandlerTest.this.size + 2), (int)bpelExecList.size());
                return null;
            }
        });
        this.call(parts1, portTypeQName, "continue");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Repository repository = EnvTool.getRepository();
                List bpelExecList = repository.getInstances();
                Assert.assertEquals((int)(DeleteFinishedInstanceHandlerTest.this.size + 1), (int)bpelExecList.size());
                return null;
            }
        });
        final BpelTestCase.CallResult callResult3 = this.call(parts3, portTypeQName, "submit");
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Repository repository = EnvTool.getRepository();
                List bpelExecList = repository.getInstances();
                Assert.assertEquals((int)(DeleteFinishedInstanceHandlerTest.this.size + 2), (int)bpelExecList.size());
                return null;
            }
        });
        this.call(parts2, portTypeQName, "continue");
        this.call(parts3, portTypeQName, "continue");
        this.waitForInstanceEnd(callResult2.getProcessInstanceUUID());
        this.waitForInstanceEnd(callResult3.getProcessInstanceUUID());
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Repository repository = EnvTool.getRepository();
                List bpelExecList = repository.getInstances();
                Assert.assertEquals((int)DeleteFinishedInstanceHandlerTest.this.size, (int)bpelExecList.size());
                callResult.getMessageCarrier().getMessage();
                callResult2.getMessageCarrier().getMessage();
                callResult3.getMessageCarrier().getMessage();
                DeleteFinishedInstanceHandlerTest.this.deleteInstance(callResult);
                DeleteFinishedInstanceHandlerTest.this.deleteInstance(callResult2);
                DeleteFinishedInstanceHandlerTest.this.deleteInstance(callResult3);
                return null;
            }
        });
    }
}

