/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.versioning;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.facade.QueryRuntimeAPI;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Hello2VersioningTest
extends RemoteTestCase {
    public void testVersion1() throws InterruptedException, ExecutionException, TimeoutException {
        String processName = "hello2";
        ExecutorService execSvc = Executors.newCachedThreadPool();
        ProcessDefinition pd1 = this.deploy("hello2-v1");
        Future<Void> f1 = execSvc.submit(new Hello2CallHelloPT());
        try {
            f1.get(3L, TimeUnit.SECONDS);
            Assert.fail((String)"service should not reply before second call is done");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        Future<Void> f2 = execSvc.submit(new Hello2CallHelloTextPT());
        f1.get(30L, TimeUnit.SECONDS);
        f2.get(30L, TimeUnit.SECONDS);
        this.undeploy(pd1.getUUID());
    }

    public void testVersion2() throws InterruptedException, ExecutionException, TimeoutException {
        String processName = "hello2";
        ExecutorService execSvc = Executors.newCachedThreadPool();
        ProcessDefinition pd2 = this.deploy("hello2-v2");
        Future<Void> f3 = execSvc.submit(new Hello2CallHelloPT());
        f3.get(30L, TimeUnit.SECONDS);
        this.undeploy(pd2.getUUID());
    }

    public void testVersion1Version2Version1() throws Exception {
        String processName = "hello2";
        ExecutorService execSvc = Executors.newCachedThreadPool();
        QueryRuntimeAPI queryRuntimeAPI = (QueryRuntimeAPI)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
        ProcessDefinition pd1 = this.deploy("hello2-v1");
        Assert.assertEquals((int)0, (int)queryRuntimeAPI.findProcessInstances(pd1.getUUID()).size());
        Future<Void> f1 = execSvc.submit(new Hello2CallHelloPT());
        try {
            f1.get(3L, TimeUnit.SECONDS);
            Assert.fail((String)"service should not reply before second call is done");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        Assert.assertEquals((int)0, (int)queryRuntimeAPI.findProcessInstances(pd1.getUUID()).size());
        Future<Void> f2 = execSvc.submit(new Hello2CallHelloTextPT());
        f1.get(30L, TimeUnit.SECONDS);
        f2.get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd1.getUUID()).size());
        ProcessDefinition pd2 = this.deploy("hello2-v2");
        Future<Void> f6 = execSvc.submit(new Hello2CallHelloTextPT());
        try {
            f6.get(3L, TimeUnit.SECONDS);
            Assert.fail((String)"service should not reply before second call is done");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd1.getUUID()).size());
        Assert.assertEquals((int)0, (int)queryRuntimeAPI.findProcessInstances(pd2.getUUID()).size());
        Future<Void> f3 = execSvc.submit(new Hello2CallHelloPT());
        f3.get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd1.getUUID()).size());
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd2.getUUID()).size());
        this.undeploy(pd2.getUUID());
        Future<Void> f4 = execSvc.submit(new Hello2CallHelloPT());
        try {
            f4.get(3L, TimeUnit.SECONDS);
            Assert.fail((String)"service should not reply before second call is done");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd1.getUUID()).size());
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd2.getUUID()).size());
        Future<Void> f5 = execSvc.submit(new Hello2CallHelloTextPT());
        f4.get(30L, TimeUnit.SECONDS);
        f5.get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((int)2, (int)queryRuntimeAPI.findProcessInstances(pd1.getUUID()).size());
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd2.getUUID()).size());
        this.undeploy(pd1.getUUID());
    }

    public void testVersion2Version1Version2() throws Exception {
        String processName = "hello2";
        ExecutorService execSvc = Executors.newCachedThreadPool();
        QueryRuntimeAPI queryRuntimeAPI = (QueryRuntimeAPI)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
        ProcessDefinition pd2 = this.deploy("hello2-v2");
        Assert.assertEquals((int)0, (int)queryRuntimeAPI.findProcessInstances(pd2.getUUID()).size());
        Future<Void> f3 = execSvc.submit(new Hello2CallHelloPT());
        f3.get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd2.getUUID()).size());
        ProcessDefinition pd1 = this.deploy("hello2-v1");
        Future<Void> f1 = execSvc.submit(new Hello2CallHelloPT());
        try {
            f1.get(3L, TimeUnit.SECONDS);
            Assert.fail((String)"service should not reply before second call is done");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        Assert.assertEquals((int)0, (int)queryRuntimeAPI.findProcessInstances(pd1.getUUID()).size());
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd2.getUUID()).size());
        Future<Void> f2 = execSvc.submit(new Hello2CallHelloTextPT());
        f1.get(30L, TimeUnit.SECONDS);
        f2.get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd1.getUUID()).size());
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd2.getUUID()).size());
        this.undeploy(pd1.getUUID());
        Future<Void> f4 = execSvc.submit(new Hello2CallHelloPT());
        f4.get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((int)1, (int)queryRuntimeAPI.findProcessInstances(pd1.getUUID()).size());
        Assert.assertEquals((int)2, (int)queryRuntimeAPI.findProcessInstances(pd2.getUUID()).size());
        this.undeploy(pd2.getUUID());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Hello2CallHelloTextPT
    implements Callable<Void> {
        Hello2CallHelloTextPT() {
        }

        @Override
        public Void call() throws Exception {
            String endpoint;
            String part = "<setHelloText>coucou_</setHelloText>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/hello2/setHelloText", (String)"<setHelloText>coucou_</setHelloText>");
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)(endpoint = Hello2VersioningTest.this.getDefaultEndpoint("helloTextPT")));
            if (response != null) {
                SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)"setHelloText", (String)result.getElementName().getLocalName());
                Assert.assertNotNull((Object)result.getFirstChild());
                Assert.assertTrue((boolean)(result.getFirstChild() instanceof Text));
                Text text = (Text)result.getFirstChild();
                Assert.assertEquals((String)"coucou_", (String)text.getNodeValue());
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Hello2CallHelloPT
    implements Callable<Void> {
        Hello2CallHelloPT() {
        }

        @Override
        public Void call() throws Exception {
            String endpoint;
            String part = "<name>toto</name>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/hello2/sayHello", (String)"<name>toto</name>");
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)(endpoint = Hello2VersioningTest.this.getDefaultEndpoint("helloPT")));
            if (response != null) {
                Assert.assertNotNull(response.getSOAPBody().getChildElements().next());
                Assert.assertTrue((String)XmlUtil.toString((Node)response.getSOAPBody()), (boolean)(response.getSOAPBody().getChildElements().next() instanceof SOAPBodyElement));
                SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                Assert.assertNotNull((Object)result);
                Assert.assertNotNull((Object)result.getFirstChild());
                Assert.assertTrue((boolean)(result.getFirstChild() instanceof Text));
                Text text = (Text)result.getFirstChild();
                Assert.assertEquals((String)"coucou_toto", (String)text.getData());
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            return null;
        }
    }
}

