/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.faultManagement.catch_;

import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.deployment.Deployer;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.FailWS;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CatchTest
extends BpelTestCase {
    public CatchTest() {
        super("http://orchestra.ow2.org/catch_", "catch_");
    }

    public void testVariablesInFH() throws Exception {
        this.deploy("variables");
        Document messageDoc = XmlUtil.getNewDocument();
        messageDoc.appendChild(messageDoc.createElement("message"));
        Element partElt = messageDoc.createElement("dummyElement");
        messageDoc.getDocumentElement().appendChild(partElt);
        partElt.appendChild(messageDoc.importNode(this.createElement("http://www.w3.org/2001/XMLSchema", "integer").getDocumentElement(), true));
        this.launch(new QName("wsFault"), messageDoc, "catchAll3var3catchAll2catchMissingVar");
        this.undeploy();
    }

    public void testFaultMatchingCatchAllWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch(null, null, "catchAll");
        this.undeploy();
    }

    public void testFaultMatchingCatchAllWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch(null, null, "catchAll");
        this.undeploy();
    }

    public void testFaultWithoutVariableMatchingFaultNameWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch("FaultMatchingFaultName");
        this.undeploy();
    }

    public void testFaultWithoutVariableMatchingFaultNameWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch("FaultMatchingFaultName");
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultNameAndMessageTypeWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch("FaultMatchingFaultTypeAndFaultName", "dummyElement", this.createElement("http://www.w3.org/2001/XMLSchema", "integer"));
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultNameAndMessageTypeWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch("FaultMatchingFaultTypeAndFaultName", "dummyElement", this.createElement("http://www.w3.org/2001/XMLSchema", "integer"));
        this.undeploy();
    }

    public void testFaultVariableElementAndName() throws Exception {
        this.deploy("faultVariableElementAndName");
        this.launch("FaultMatchingFaultElementAndNamesomeRandomCatchRequest");
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultNameOnlyWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch("FaultMatchingFaultName", "dummyElement", this.createElement());
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultNameOnlyWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch("FaultMatchingFaultName", "dummyElement", this.createElement());
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultMessageTypeWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch("FaultMatchingFaultType", "dummyElement", this.createElement("http://www.w3.org/2001/XMLSchema", "integer"));
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultMessageTypeWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch("FaultMatchingFaultType", "dummyElement", this.createElement("http://www.w3.org/2001/XMLSchema", "integer"));
        this.undeploy();
    }

    public void testFaultVariableMessageTypeWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch("FaultVariableMatchingFaultType", "dummyElement", this.createElement("http://orchestra.ow2.org/catch_", "catch_Request"));
        this.undeploy();
    }

    public void testFaultVariableMessageTypeWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch("FaultVariableMatchingFaultType", "dummyElement", this.createElement("http://orchestra.ow2.org/catch_", "catch_Request"));
        this.undeploy();
    }

    public void testFaultVariableElement() throws Exception {
        this.deploy("faultVariableElement");
        this.launch("FaultMatchingFaultElementsomeRandomCatchRequest");
        this.undeploy();
    }

    public void deploy(String suffix) {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + suffix + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public void launch(String qname) {
        this.launch(new QName(qname), null, "catch" + qname);
    }

    public void launch(String qname, String elementName, Document element) {
        Document messageDoc = XmlUtil.getNewDocument();
        messageDoc.appendChild(messageDoc.createElement("message"));
        Element partElt = messageDoc.createElement(elementName);
        messageDoc.getDocumentElement().appendChild(partElt);
        partElt.appendChild(messageDoc.importNode(element.getDocumentElement(), true));
        this.launch(new QName(qname), messageDoc, "catch" + qname);
    }

    public void launch(QName faultName, Document faultParts, String responseMiddle) {
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + responseMiddle + message;
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        FailWS failWS = new FailWS();
        WSRepository.addWS(FailWS.PORTTYPE_QNAME, failWS);
        if (faultName != null) {
            failWS.setExceptionFault(faultName, faultParts);
        } else {
            failWS.resetException();
        }
        HashMap<String, Element> parts = new HashMap<String, Element>();
        Element el = BpelXmlUtil.createElement((String)"http://orchestra.ow2.org/catch_", (String)"catch_Request");
        el.setTextContent(message);
        parts.put("input", el);
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "start");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        this.deleteInstances(1);
        WSRepository.removeWS(FailWS.PORTTYPE_QNAME);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }

    private Document createElement() {
        Element element = BpelXmlUtil.createElement((String)"dummyElement");
        return element.getOwnerDocument();
    }

    private Document createElement(String namespace, String localname) {
        Element element = BpelXmlUtil.createElement((QName)new QName(namespace, localname));
        element.setTextContent("dummyElement");
        return element.getOwnerDocument();
    }

    public void testOnEventCatchInAssociatedScope() {
        final QName onEventQName = new QName("http://example.com/onEvent", "onEvent");
        this.deploy(((Object)((Object)this)).getClass().getResource("catch_onEvent.bpel"), ((Object)((Object)this)).getClass().getResource("catch_onEvent.wsdl"));
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        QName portTypeQName = new QName("http://example.com/onEvent", "onEventPT");
        HashMap<String, Element> parts1 = new HashMap<String, Element>();
        parts1.put("id", BpelXmlUtil.createElementWithContent((String)"0"));
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("id", BpelXmlUtil.createElementWithContent((String)message));
        BpelTestCase.CallResult result = this.call(parts1, portTypeQName, "init", onEventQName);
        this.call(parts2, portTypeQName, "incrInt", onEventQName).getMessageCarrier().getMessage();
        this.call(parts2, portTypeQName, "incrInt", onEventQName).getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "validate", onEventQName);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        this.deleteInstance(result);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Deployer deployer = new Deployer();
                deployer.undeploy(onEventQName, environment);
                return null;
            }
        });
    }

    public void testOnEventCatchInAncestorScope() {
        final QName onEventQName = new QName("http://example.com/onEvent", "onEvent");
        this.deploy(((Object)((Object)this)).getClass().getResource("catch_onEvent.bpel"), ((Object)((Object)this)).getClass().getResource("catch_onEvent.wsdl"));
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        String message = UUID.randomUUID().toString();
        String expectedResponse = "ancestor";
        QName portTypeQName = new QName("http://example.com/onEvent", "onEventPT");
        HashMap<String, Element> parts1 = new HashMap<String, Element>();
        parts1.put("id", BpelXmlUtil.createElementWithContent((String)"0"));
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("id", BpelXmlUtil.createElementWithContent((String)message));
        BpelTestCase.CallResult result = this.call(parts1, portTypeQName, "init", onEventQName);
        this.call(parts2, portTypeQName, "incrIntOneWay", onEventQName);
        this.call(parts2, portTypeQName, "incrIntOneWay", onEventQName);
        this.call(parts1, portTypeQName, "validate", onEventQName);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        Assert.assertEquals((String)"ancestor", (String)saveWS.getBuffer());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        this.deleteInstance(result);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Deployer deployer = new Deployer();
                deployer.undeploy(onEventQName, environment);
                return null;
            }
        });
    }

    public void testOnEventCatchInEnclosingScope() {
        final QName onEventQName = new QName("http://example.com/onEvent", "onEvent");
        this.deploy(((Object)((Object)this)).getClass().getResource("catch_onEvent2.bpel"), ((Object)((Object)this)).getClass().getResource("catch_onEvent.wsdl"));
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        String message = UUID.randomUUID().toString();
        String expectedResponse = "ancestor";
        QName portTypeQName = new QName("http://example.com/onEvent", "onEventPT");
        HashMap<String, Element> parts1 = new HashMap<String, Element>();
        parts1.put("id", BpelXmlUtil.createElementWithContent((String)"0"));
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("id", BpelXmlUtil.createElementWithContent((String)message));
        BpelTestCase.CallResult result = this.call(parts1, portTypeQName, "init", onEventQName);
        this.call(parts2, portTypeQName, "incrIntOneWay", onEventQName);
        this.call(parts2, portTypeQName, "incrIntOneWay", onEventQName);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        Assert.assertEquals((String)"ancestor", (String)saveWS.getBuffer());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        this.deleteInstance(result);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Deployer deployer = new Deployer();
                deployer.undeploy(onEventQName, environment);
                return null;
            }
        });
    }
}

