/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.pick;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class PickOnAlarmTest
extends BpelTestCase {
    public PickOnAlarmTest() {
        super("http://example.com/pickOnAlarm", "pickOnAlarm");
    }

    public void testPickOnAlarm() {
        this.deploy();
        this.launch(2L);
        this.launch(4L);
        this.launch(6L);
        this.undeploy();
    }

    public void launch(long durationInSec) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("duration", BpelXmlUtil.createElementWithContent((String)("PT" + durationInSec + "S")));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        long startTime = System.currentTimeMillis() / 1000L * 1000L;
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        MessageVariable message = callResult.getMessageCarrier().getMessage();
        long endTime = System.currentTimeMillis();
        Element durationElement = message.getPartValue("duration");
        this.assertNoElementChild(durationElement);
        long result = Long.parseLong(durationElement.getTextContent());
        if (durationInSec < 4L) {
            Assert.assertEquals((long)0L, (long)result);
            Assert.assertTrue((startTime + 1000L * durationInSec <= endTime ? 1 : 0) != 0);
        } else if (durationInSec > 4L) {
            Assert.assertEquals((long)1L, (long)result);
            Assert.assertTrue((startTime + 4000L <= endTime ? 1 : 0) != 0);
        } else if (result != 0L && result != 1L) {
            Assert.fail((String)("expected 0 or 1 but got " + result));
        }
        this.deleteInstance(callResult);
    }
}

