/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.integration.evaluate;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.integration.evaluate.Analyze;
import org.ow2.orchestra.test.integration.evaluate.Stock;
import org.ow2.orchestra.test.integration.evaluate.Weather;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class EvaluateTest
extends BpelTestCase {
    private static final String WEATHER_NS = "http://petals.ow2.org";
    private static final String STOCK_NS = "http://petals.ow2.org";
    private static final String ANALYZE_NS = "http://petals.ow2.org";
    private static final String WEATHER_PT_NAME = "soapWeatherInterface";
    private static final String STOCK_PT_NAME = "soapStockInterface";
    private static final String ANALYZE_PT_NAME = "analyzer";

    public EvaluateTest() {
        super("http://petals.ow2.org/wsportal/", "wsPortalBPEL");
    }

    public void testWeatherProcess() {
        this.process("weather");
    }

    public void testStockProcess() {
        this.process("stock");
    }

    public void process(String op) {
        this.deploy(((Object)((Object)this)).getClass().getResource("wsportal.bpel"), ((Object)((Object)this)).getClass().getResource("wsportal.wsdl"));
        Element processElement = XmlUtil.getDocumentWithOneElement((QName)new QName(this.getProcessNamespace(), "process"));
        Element requestElement = processElement.getOwnerDocument().createElementNS(this.getProcessNamespace(), "request");
        requestElement.setTextContent("!" + op + " toulouse");
        processElement.appendChild(requestElement);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("request", requestElement);
        QName portTypeQName = new QName(this.getProcessNamespace(), "wsportal");
        String operationName = "process";
        QName analyzeQN = new QName("http://petals.ow2.org", ANALYZE_PT_NAME);
        QName weatherQN = new QName("http://petals.ow2.org", WEATHER_PT_NAME);
        QName stockQN = new QName("http://petals.ow2.org", STOCK_PT_NAME);
        WSRepository.addWS(analyzeQN, new Analyze("http://petals.ow2.org", op));
        WSRepository.addWS(weatherQN, new Weather("http://petals.ow2.org"));
        WSRepository.addWS(stockQN, new Stock("http://petals.ow2.org"));
        BpelTestCase.CallResult result = this.call(parts, portTypeQName, "process");
        MessageVariable reply = result.getMessageCarrier().getMessage();
        Assert.assertNotNull((Object)reply);
        Element responseElement = reply.getPartValue("response");
        if (op.equals("weather")) {
            Assert.assertNotNull((Object)responseElement.getElementsByTagName("weatherReturn").item(0));
            Assert.assertEquals((String)((Element)responseElement.getElementsByTagName("weatherReturn").item(0)).getTextContent(), (String)"18");
        } else {
            Assert.assertNotNull((Object)responseElement.getElementsByTagName("stockReturn").item(0));
            Assert.assertEquals((String)((Element)responseElement.getElementsByTagName("stockReturn").item(0)).getTextContent(), (String)"18");
        }
        this.deleteInstance(result);
        WSRepository.removeWS(analyzeQN);
        WSRepository.removeWS(weatherQN);
        WSRepository.removeWS(stockQN);
        this.undeploy();
    }
}

