/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.wait;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.activities.wait.WaitTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class WaitLoadTest
extends WaitTestCase {
    public WaitLoadTest() {
        super("http://example.com/waitLoad", "waitLoad");
    }

    public void testWait() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void launch() {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        Date date = new Date(System.currentTimeMillis() + 2000L);
        String deadline = null;
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlCalendar = datatypeFactory.newXMLGregorianCalendar();
            GregorianCalendar calendar = xmlCalendar.toGregorianCalendar();
            calendar.setTime(date);
            xmlCalendar = datatypeFactory.newXMLGregorianCalendar(calendar);
            deadline = xmlCalendar.toString();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Assert.fail();
        }
        Assert.assertNotNull(deadline);
        parts.put("deadline", BpelXmlUtil.createElementWithContent(deadline));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        long startTimeSecond = System.currentTimeMillis() / 1000L;
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        MessageVariable reply = callResult.getMessageCarrier().getMessage();
        int waitNumber = Integer.parseInt(reply.getPartValue("waitNumber").getTextContent());
        long endTimeSecond = System.currentTimeMillis() / 1000L;
        Assert.assertTrue((startTimeSecond + 2L <= endTimeSecond ? 1 : 0) != 0);
        Assert.assertEquals((int)10, (int)waitNumber);
        this.deleteInstance(callResult);
    }
}

