/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.versioning;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderingServiceVersioningTest
extends RemoteTestCase {
    private static final int TIMEOUT = 10;
    private final ExecutorService execSvc = Executors.newCachedThreadPool();

    public void testOrderingService() throws TimeoutException, InterruptedException, ExecutionException, SOAPException {
        boolean id1 = false;
        int client1 = 3;
        int id2 = 4;
        int client2 = 7;
        ProcessDefinition pd1 = this.deployV1();
        Future<String> instance1 = this.sendInitMsg(0, 3, "John");
        this.sendOrderMsg(0, 3, "product1").get(10L, TimeUnit.SECONDS);
        this.sendOrderMsg(0, 7, "product2").get(10L, TimeUnit.SECONDS);
        this.sendOrderMsg(0, 3, "product3").get(10L, TimeUnit.SECONDS);
        this.sendValidateMsg(0, 3);
        String res1 = instance1.get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"John received product1, product2, product3, ", (String)res1);
        this.undeploy(pd1.getUUID());
        ProcessDefinition pd2 = this.deployV2();
        Future<String> instance2 = this.sendInitMsg(4, 7, "Paul");
        this.sendOrderMsg(4, 7, "product1").get(10L, TimeUnit.SECONDS);
        try {
            this.sendOrderMsg(4, 3, "product2").get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"No response expected");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        this.sendOrderMsg(4, 7, "product3").get(10L, TimeUnit.SECONDS);
        Thread.sleep(1000L);
        this.sendValidateMsg(4, 7);
        String res2 = instance2.get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Paul ordered product1, product3, ", (String)res2);
        this.undeploy(pd2.getUUID());
    }

    public void testOrderingServiceVersioning() throws TimeoutException, InterruptedException, ExecutionException, SOAPException {
        int id1 = 10;
        int client1 = 13;
        int id2 = 14;
        int client2 = 17;
        ProcessDefinition pd1 = this.deployV1();
        Future<String> instance1 = this.sendInitMsg(10, 13, "John");
        ProcessDefinition pd2 = this.deployV2();
        Future<String> instance2 = this.sendInitMsg(14, 17, "Paul");
        this.sendOrderMsg(10, 13, "product1").get(10L, TimeUnit.SECONDS);
        this.sendOrderMsg(14, 17, "product1").get(10L, TimeUnit.SECONDS);
        this.sendOrderMsg(10, 17, "product2").get(10L, TimeUnit.SECONDS);
        try {
            this.sendOrderMsg(14, 13, "product2").get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"No response expected");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        this.sendOrderMsg(10, 13, "product3").get(10L, TimeUnit.SECONDS);
        this.sendOrderMsg(14, 17, "product3").get(10L, TimeUnit.SECONDS);
        Thread.sleep(1000L);
        this.sendValidateMsg(10, 13);
        this.sendValidateMsg(14, 17);
        String res1 = instance1.get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"John received product1, product2, product3, ", (String)res1);
        String res2 = instance2.get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Paul ordered product1, product3, ", (String)res2);
        this.undeploy(pd1.getUUID());
        this.undeploy(pd2.getUUID());
    }

    private Future<String> sendInitMsg(final int id, final int clientId, final String clientName) {
        return this.execSvc.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String endpoint;
                String part = "<initInfo xmlns='http://orchestra.ow2.org/demos/orderingService'><id>" + id + "</id>" + "<clientId>" + clientId + "</clientId>" + "<clientName>" + clientName + "</clientName>" + "</initInfo>";
                SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/demos/orderingService/init", (String)part);
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)(endpoint = OrderingServiceVersioningTest.this.getDefaultEndpoint("initPort")));
                if (response != null) {
                    SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                    Assert.assertNotNull((Object)result);
                    Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)"response", (String)result.getElementName().getLocalName());
                    Assert.assertEquals((int)3, (int)XmlUtil.elements((Element)result).size());
                    Assert.assertEquals((String)Integer.toString(id), (String)((Element)XmlUtil.elements((Element)result).get(0)).getTextContent());
                    Assert.assertEquals((String)Integer.toString(clientId), (String)((Element)XmlUtil.elements((Element)result).get(1)).getTextContent());
                    return ((Element)XmlUtil.elements((Element)result).get(2)).getTextContent();
                }
                Assert.assertTrue((String)"No return available", (boolean)false);
                return null;
            }
        });
    }

    private void sendValidateMsg(int id, int clientId) throws SOAPException {
        String part = "<validateInfo xmlns='http://orchestra.ow2.org/demos/orderingService'><id>" + id + "</id>" + "<clientId>" + clientId + "</clientId>" + "</validateInfo>";
        SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/demos/orderingService/validate", (String)part);
        String endpoint = this.getDefaultEndpoint("validatePort");
        SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
        Assert.assertNull((String)"No return should be available.", (Object)response);
    }

    private Future<Void> sendOrderMsg(final int id, final int clientId, final String productName) throws SOAPException {
        return this.execSvc.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String part = "<orderInfo xmlns='http://orchestra.ow2.org/demos/orderingService'><id>" + id + "</id>" + "<clientId>" + clientId + "</clientId>" + "<productName>" + productName + "</productName>" + "</orderInfo>";
                SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/demos/orderingService/order", (String)part);
                String endpoint = OrderingServiceVersioningTest.this.getDefaultEndpoint("orderPort");
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                Assert.assertNotNull((String)"No return available.", (Object)response);
                return null;
            }
        });
    }

    public ProcessDefinition deployV1() {
        return this.deploy("orderingService-v1");
    }

    public ProcessDefinition deployV2() {
        return this.deploy("orderingService-v2");
    }
}

