/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.versioning;

import junit.framework.Assert;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.Misc;

public class VersioningMonitoringTest
extends RemoteTestCase {
    private final String processName = "helloworld";

    public void testVersioningMonitoring() throws Exception {
        RemoteDeployerMBean remoteDeployer;
        ProcessDefinition pd = this.deploy(this.processName + "-v1");
        RemoteDeployerMBean managementAPI = remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
        RemoteDeployerMBean queryDefinitionAPI = remoteDeployer;
        ProcessDefinition processDefinition = queryDefinitionAPI.getProcessDefinition(pd.getUUID());
        Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processDefinition.getType());
        Assert.assertEquals((Object)ProcessState.ACTIVE, (Object)processDefinition.getState());
        Assert.assertEquals((int)1, (int)processDefinition.getStateUpdates().size());
        managementAPI.retire(pd.getUUID());
        processDefinition = queryDefinitionAPI.getProcessDefinition(pd.getUUID());
        Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processDefinition.getType());
        Assert.assertEquals((Object)ProcessState.RETIRED, (Object)processDefinition.getState());
        Assert.assertEquals((int)2, (int)processDefinition.getStateUpdates().size());
        managementAPI.activate(pd.getUUID());
        processDefinition = queryDefinitionAPI.getProcessDefinition(pd.getUUID());
        Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processDefinition.getType());
        Assert.assertEquals((Object)ProcessState.ACTIVE, (Object)processDefinition.getState());
        Assert.assertEquals((int)3, (int)processDefinition.getStateUpdates().size());
        managementAPI.undeploy(pd.getUUID());
        processDefinition = queryDefinitionAPI.getProcessDefinition(pd.getUUID());
        Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processDefinition.getType());
        Assert.assertEquals((Object)ProcessState.UNDEPLOYED, (Object)processDefinition.getState());
        Assert.assertEquals((int)4, (int)processDefinition.getStateUpdates().size());
    }
}

