/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.orchestra.util.DocumentProxy;
import org.ow2.orchestra.util.Misc;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlUtil {
    private static final Logger LOG = Logger.getLogger(XmlUtil.class.getName());
    private static DocumentBuilderFactory documentBuilderFactory;
    private static TransformerFactory transformerFactory;
    private static ThreadLocal<Transformer> transformer;
    private static ThreadLocal<DocumentBuilder> documentBuilder;

    private XmlUtil() {
    }

    public static List<Element> elements(Element element, String tagName) {
        ArrayList<Element> elements = null;
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                String childTagName;
                Node child = nodeList.item(i);
                if (!Element.class.isAssignableFrom(child.getClass()) || !(childTagName = XmlUtil.getTagLocalName(childElement = (Element)child)).equals(tagName)) continue;
                if (elements == null) {
                    elements = new ArrayList<Element>();
                }
                elements.add(childElement);
            }
        }
        return elements;
    }

    public static List<Element> elements(Element element, Set<String> allowedTagNames) {
        ArrayList<Element> elements = null;
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                String childTagName;
                Node child = nodeList.item(i);
                if (!Element.class.isAssignableFrom(child.getClass()) || !allowedTagNames.contains(childTagName = XmlUtil.getTagLocalName(childElement = (Element)child))) continue;
                if (elements == null) {
                    elements = new ArrayList<Element>();
                }
                elements.add(childElement);
            }
        }
        return elements;
    }

    public static Element element(Element element, String tagName) {
        Element childElement = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && childElement == null; ++i) {
            Node child = nodeList.item(i);
            if (!Element.class.isAssignableFrom(child.getClass()) || !XmlUtil.getTagLocalName((Element)child).equals(tagName)) continue;
            childElement = (Element)child;
        }
        return childElement;
    }

    public static Element element(Element element, String ns, String localName) {
        Element childElement = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && childElement == null; ++i) {
            Node child = nodeList.item(i);
            if (!Element.class.isAssignableFrom(child.getClass()) || child.getLocalName() == null || !child.getLocalName().equals(localName) || child.getNamespaceURI() == null || !child.getNamespaceURI().equals(ns)) continue;
            childElement = (Element)child;
        }
        return childElement;
    }

    public static List<Element> elements(Element element) {
        NodeList nodeList;
        ArrayList<Element> elements = null;
        if (element != null && (nodeList = element.getChildNodes()) != null && nodeList.getLength() > 0) {
            elements = new ArrayList<Element>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                elements.add((Element)node);
            }
        }
        return elements;
    }

    public static List<Element> elements(Element father, String ns, String localName) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        NodeList nl = father.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || n.getLocalName() == null || !n.getLocalName().equals(localName) || n.getNamespaceURI() == null || !n.getNamespaceURI().equals(ns)) continue;
            matchingElements.add((Element)n);
        }
        return matchingElements;
    }

    public static List<Element> elementsQName(Element element, Set<QName> allowedTagNames) {
        ArrayList<Element> elements = null;
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                QName childElementQName;
                Node child = nodeList.item(i);
                if (!Element.class.isAssignableFrom(child.getClass()) || !allowedTagNames.contains(childElementQName = new QName((childElement = (Element)child).getNamespaceURI(), childElement.getLocalName()))) continue;
                if (elements == null) {
                    elements = new ArrayList<Element>();
                }
                elements.add(childElement);
            }
        }
        return elements;
    }

    public static Element element(Element element) {
        Element onlyChild = null;
        List<Element> elements = XmlUtil.elements(element);
        if (elements != null && !elements.isEmpty()) {
            onlyChild = elements.get(0);
        }
        return onlyChild;
    }

    public static String toString(Node node) {
        DocumentProxy dp;
        InvocationHandler ih;
        if (node == null) {
            return null;
        }
        if (node instanceof Document && Proxy.isProxyClass(node.getClass()) && (ih = Proxy.getInvocationHandler(node)) instanceof DocumentProxy && !(dp = (DocumentProxy)ih).isInitialized()) {
            return dp.getDocumentAsString();
        }
        DOMSource source = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StreamResult result = new StreamResult(printWriter);
        Transformer domTransformer = null;
        try {
            domTransformer = XmlUtil.getTransformer();
            domTransformer.transform(source, result);
        }
        catch (Exception e) {
            Misc.fastDynamicLog(LOG, Level.WARNING, "couldn't transform dom element into string representation", new Object[0]);
            if (node instanceof Element) {
                return "<" + ((Element)node).getTagName() + " ... >...</" + ((Element)node).getTagName() + ">";
            }
            return node.getTextContent();
        }
        printWriter.close();
        return stringWriter.toString();
    }

    public static String getContentText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof CharacterData)) continue;
            CharacterData characterData = (CharacterData)node;
            buffer.append(characterData.getData());
        }
        return buffer.toString();
    }

    public static boolean isTextOnly(Element element) {
        boolean isTextOnly = true;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && isTextOnly; ++i) {
            if (!Element.class.isAssignableFrom(nodeList.item(i).getClass())) continue;
            isTextOnly = false;
        }
        return isTextOnly;
    }

    public static List<Attr> attributes(Element element) {
        NamedNodeMap attributeMap = element.getAttributes();
        if (attributeMap == null || attributeMap.getLength() == 0) {
            return null;
        }
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        for (int i = 0; i < attributeMap.getLength(); ++i) {
            attributes.add((Attr)attributeMap.item(i));
        }
        return attributes;
    }

    public static String getTagLocalName(Element element) {
        if (element == null) {
            return null;
        }
        String localName = element.getLocalName();
        if (localName != null) {
            return localName;
        }
        return element.getTagName();
    }

    public static String attribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    public static Boolean parseBooleanValue(String valueText) {
        if (valueText != null) {
            if ("true".equals(valueText) || "enabled".equals(valueText) || "on".equals(valueText)) {
                return Boolean.TRUE;
            }
            if ("false".equals(valueText) || "disabled".equals(valueText) || "off".equals(valueText)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static String errorMessageAttribute(Element element, String attributeName, String attributeValue, String message) {
        return "attribute <" + XmlUtil.getTagLocalName(element) + " " + attributeName + "=\"" + attributeValue + "\" " + message;
    }

    public static List<String> parseList(Element element, String singularTagName) {
        String text = XmlUtil.attribute(element, singularTagName + "s");
        if ("*".equals(text)) {
            text = null;
        }
        if (element.hasAttribute(singularTagName)) {
            String eventText = element.getAttribute(singularTagName);
            text = text == null ? eventText : text + "," + eventText;
        }
        List<String> eventNames = XmlUtil.parseCommaSeparatedList(text);
        return eventNames;
    }

    public static List<String> parseCommaSeparatedList(String commaSeparatedListText) {
        ArrayList<String> entries = null;
        if (commaSeparatedListText != null && !"*".equals(commaSeparatedListText)) {
            StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListText, ", ");
            while (tokenizer.hasMoreTokens()) {
                if (entries == null) {
                    entries = new ArrayList<String>();
                }
                entries.add(tokenizer.nextToken());
            }
        }
        return entries;
    }

    public static NamespaceValue attributeNamespaceValue(Element element, String attributeName) {
        NamespaceValue namespaceValue = null;
        String text = XmlUtil.attribute(element, attributeName);
        if (text != null) {
            int colonIndex = text.indexOf(58);
            if (colonIndex == -1) {
                namespaceValue = new NamespaceValue(null, text);
            } else {
                String prefix = text.substring(0, colonIndex);
                String localPart = null;
                if (text.length() > colonIndex + 1) {
                    localPart = text.substring(colonIndex + 1);
                }
                namespaceValue = new NamespaceValue(prefix, localPart);
            }
        }
        return namespaceValue;
    }

    public static QName attributeQName(Element element, String attributeName) {
        QName qname = null;
        NamespaceValue namespaceValue = XmlUtil.attributeNamespaceValue(element, attributeName);
        String text = XmlUtil.attribute(element, attributeName);
        if (namespaceValue != null) {
            if (namespaceValue.getPrefix() == null) {
                qname = new QName(text);
            } else {
                String uri = element.lookupNamespaceURI(namespaceValue.getPrefix());
                if (uri == null) {
                    throw new IllegalStateException("unknown prefix in qname " + text);
                }
                if (namespaceValue.getLocalPart() == null) {
                    throw new IllegalStateException("no local part in qname " + text);
                }
                qname = new QName(uri, namespaceValue.getLocalPart(), namespaceValue.getPrefix());
            }
        }
        return qname;
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (documentBuilderFactory == null) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return documentBuilderFactory;
    }

    public static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", 2);
            }
            catch (IllegalArgumentException e) {
                Misc.fastDynamicLog(LOG, Level.FINEST, "Attribute 'indent-number' not supported by current transformer factory. Xml output may not be indented correctly.", new Object[0]);
            }
        }
        return transformerFactory;
    }

    public static QName getQNameFromString(Element element, String qnameAsString) {
        if (qnameAsString == null || element == null) {
            return null;
        }
        int colonIndex = qnameAsString.indexOf(":");
        String prefix = qnameAsString.substring(0, colonIndex);
        String localName = qnameAsString.substring(colonIndex + 1);
        String ns = XmlUtil.getNamespaceURI(element, prefix);
        return new QName(ns, localName, prefix);
    }

    public static String getNamespaceURI(Node n, String prefix) {
        Node prefixDeclaration = n.getAttributes().getNamedItem("xmlns:" + prefix);
        if (prefixDeclaration != null) {
            return prefixDeclaration.getNodeValue();
        }
        return XmlUtil.getNamespaceURI(n.getParentNode(), prefix);
    }

    private static Transformer getTransformer() {
        return transformer.get();
    }

    private static DocumentBuilder getDocumentBuilder() {
        return documentBuilder.get();
    }

    public static Document getNewDocument() {
        return XmlUtil.getDocumentBuilder().newDocument();
    }

    public static void writeXmlFile(Document doc, File file) {
        try {
            String docAsString = XmlUtil.toString(doc);
            Misc.write(docAsString, file);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while writing xml file", e);
        }
    }

    public static ByteArrayOutputStream getNodeAsBAOS(Node n) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(1);
            byteStream.write(XmlUtil.toString(n).getBytes());
            return byteStream;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caugth when transforming node to bytestream", e);
        }
    }

    public static Document getDocumentFromString(String s) {
        return XmlUtil.getDocumentFromString(s, true);
    }

    public static Document getDocumentFromString(String s, boolean createProxy) {
        if (s == null) {
            return null;
        }
        if (createProxy) {
            return (Document)Proxy.newProxyInstance(XmlUtil.class.getClassLoader(), new Class[]{Document.class}, (InvocationHandler)new DocumentProxy(s));
        }
        String prolog = "<?xml";
        if (s.startsWith("<?xml")) {
            String prologEnd = "?>";
            int prologEndIndex = s.indexOf("?>");
            s = s.substring(prologEndIndex + "?>".length());
        }
        try {
            Document doc = XmlUtil.getDocumentBuilder().parse(new InputSource(new StringReader(s)));
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while building a document from string : " + s, e);
        }
    }

    public static Document getDocumentFromInputStream(InputStream is) {
        try {
            byte[] bytes = Misc.getAllContentFrom(is);
            return XmlUtil.getDocumentFromString(new String(bytes));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while building a document from input stream : " + is, e);
        }
    }

    public static Document getDocumentFromReader(Reader r) {
        try {
            byte[] bytes = Misc.getAllContentFrom(r);
            return XmlUtil.getDocumentFromString(new String(bytes));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while building a document from reader : " + r, e);
        }
    }

    public static Document getDocumentFromFile(File xmlFile) {
        try {
            byte[] bytes = Misc.getAllContentFrom(xmlFile);
            return XmlUtil.getDocumentFromString(new String(bytes));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while building a document from file : " + xmlFile, e);
        }
    }

    public static Document getDocumentFromURL(URL xmlUrl) {
        try {
            InputStream inStream = xmlUrl.openStream();
            return XmlUtil.getDocumentBuilder().parse(inStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse successfully xml url : " + xmlUrl, e);
        }
    }

    public static Element getDocumentWithOneElement(QName elementQName) {
        Document document = XmlUtil.getNewDocument();
        Element rootElement = document.createElementNS(elementQName.getNamespaceURI(), elementQName.getLocalPart());
        document.appendChild(rootElement);
        return rootElement;
    }

    public static Document copyDocument(Document src) {
        if (src == null) {
            return null;
        }
        Document dest = XmlUtil.getNewDocument();
        if (src.getDocumentElement() != null) {
            Node n = dest.importNode(src.getDocumentElement(), true);
            dest.appendChild(n);
        }
        return dest;
    }

    private static boolean areDocumentTypeEquals(DocumentType documentType1, DocumentType documentType2) {
        NamedNodeMap n2NamedNodeMap;
        if (!XmlUtil.safeEquals(documentType1.getPublicId(), documentType2.getPublicId())) {
            return false;
        }
        if (!XmlUtil.safeEquals(documentType1.getSystemId(), documentType2.getSystemId())) {
            return false;
        }
        if (!XmlUtil.safeEquals(documentType1.getInternalSubset(), documentType2.getInternalSubset())) {
            return false;
        }
        NamedNodeMap n1NamedNodeMap = documentType1.getEntities();
        if (!XmlUtil.areNamedNodeMapNullOrDiffLength(n1NamedNodeMap, n2NamedNodeMap = documentType2.getEntities())) {
            return false;
        }
        if (!XmlUtil.areNamedNodeMapEquals(n1NamedNodeMap, n2NamedNodeMap)) {
            return false;
        }
        n1NamedNodeMap = documentType1.getNotations();
        if (!XmlUtil.areNamedNodeMapNullOrDiffLength(n1NamedNodeMap, n2NamedNodeMap = documentType2.getNotations())) {
            return false;
        }
        return XmlUtil.areNamedNodeMapEquals(n1NamedNodeMap, n2NamedNodeMap);
    }

    private static boolean areNamedNodeMapEquals(NamedNodeMap n1NamedNodeMap, NamedNodeMap n2NamedNodeMap) {
        if (n1NamedNodeMap != null && n1NamedNodeMap.getLength() > 0) {
            int i = 0;
            for (i = 0; i < n1NamedNodeMap.getLength(); ++i) {
                Node n1Temp = n1NamedNodeMap.item(i);
                Node n2Temp = n2NamedNodeMap.item(i);
                if (n2Temp == null) {
                    return false;
                }
                n1Temp.normalize();
                n2Temp.normalize();
                if (n1Temp.isEqualNode(n2Temp)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean areNamedNodeMapNullOrDiffLength(NamedNodeMap n1NamedNodeMap, NamedNodeMap n2NamedNodeMap) {
        if (n1NamedNodeMap != null && n2NamedNodeMap == null || n1NamedNodeMap == null && n2NamedNodeMap != null) {
            return false;
        }
        if (n1NamedNodeMap == null) {
            return true;
        }
        int n1size = 0;
        for (int i = 0; i < n1NamedNodeMap.getLength(); ++i) {
            if ("http://www.w3.org/2000/xmlns/".equals(n1NamedNodeMap.item(i).getNamespaceURI())) continue;
            ++n1size;
        }
        int n2size = 0;
        for (int i = 0; i < n2NamedNodeMap.getLength(); ++i) {
            if ("http://www.w3.org/2000/xmlns/".equals(n2NamedNodeMap.item(i).getNamespaceURI())) continue;
            ++n2size;
        }
        return n1size == n2size;
    }

    public static boolean areNodeEquals(Node n1, Node n2) {
        Node n2Temp;
        Node n1Temp;
        NamedNodeMap n2NamedNodeMap;
        Misc.checkArgsNotNull(n1, n2);
        int i = 0;
        if (n1.getNodeType() != n2.getNodeType()) {
            return false;
        }
        if (n1.getNodeType() == 10 && !XmlUtil.areDocumentTypeEquals((DocumentType)n1, (DocumentType)n2)) {
            return false;
        }
        if (!XmlUtil.safeEquals(n1.getLocalName(), n2.getLocalName())) {
            return false;
        }
        if (!XmlUtil.safeEquals(n1.getNamespaceURI(), n2.getNamespaceURI())) {
            return false;
        }
        if (!XmlUtil.safeEquals(XmlUtil.getQNameOrStringValue(n1.getNodeValue(), n1), XmlUtil.getQNameOrStringValue(n2.getNodeValue(), n2))) {
            return false;
        }
        NamedNodeMap n1NamedNodeMap = n1.getAttributes();
        if (!XmlUtil.areNamedNodeMapNullOrDiffLength(n1NamedNodeMap, n2NamedNodeMap = n2.getAttributes())) {
            return false;
        }
        int j = 0;
        if (n1NamedNodeMap != null && n1NamedNodeMap.getLength() > 0) {
            for (i = 0; i < n1NamedNodeMap.getLength(); ++i) {
                boolean found = false;
                n1Temp = n1NamedNodeMap.item(i);
                if ("http://www.w3.org/2000/xmlns/".equals(n1Temp.getNamespaceURI())) break;
                String n1Name = n1Temp.getNodeName().contains(":") ? n1Temp.getLocalName() : n1Temp.getNodeName();
                n1Temp.normalize();
                for (j = 0; !found && j < n2NamedNodeMap.getLength(); ++j) {
                    n2Temp = n2NamedNodeMap.item(j);
                    String n2Name = n2Temp.getNodeName().contains(":") ? n2Temp.getLocalName() : n2Temp.getNodeName();
                    n2Temp.normalize();
                    found = XmlUtil.safeEquals(n1Name, n2Name) && XmlUtil.safeEquals(n1Temp.getNamespaceURI(), n2Temp.getNamespaceURI()) && XmlUtil.getQNameOrStringValue(n1Temp.getNodeValue(), n1Temp).equals(XmlUtil.getQNameOrStringValue(n2Temp.getNodeValue(), n2Temp));
                }
                if (found) continue;
                return false;
            }
        }
        NodeList n1ChildNodes = n1.getChildNodes();
        NodeList n2ChildNodes = n2.getChildNodes();
        if (n1ChildNodes != null && n2ChildNodes == null || n1ChildNodes == null && n2ChildNodes != null) {
            return false;
        }
        if (n1ChildNodes != null && n2ChildNodes != null) {
            if (n1ChildNodes.getLength() != n2ChildNodes.getLength()) {
                return false;
            }
            for (i = 0; i < n1ChildNodes.getLength(); ++i) {
                n1Temp = n1ChildNodes.item(i);
                n2Temp = n2ChildNodes.item(i);
                if (n2Temp == null) {
                    return false;
                }
                n1Temp.normalize();
                n2Temp.normalize();
                if (XmlUtil.areNodeEquals(n1Temp, n2Temp)) continue;
                return false;
            }
        }
        return true;
    }

    private static Object getQNameOrStringValue(String value, Node containingNode) {
        int i;
        if (value != null && (i = value.indexOf(58)) != -1 && i == value.lastIndexOf(58)) {
            String prefix = value.substring(0, i);
            String localName = value.substring(i + 1);
            String namespace = containingNode.lookupNamespaceURI(prefix);
            if (namespace != null) {
                return new QName(namespace, localName, prefix);
            }
        }
        return value;
    }

    private static boolean safeEquals(Object str1, Object str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null) {
            return false;
        }
        if (str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    static {
        transformer = new ThreadLocal<Transformer>(){

            @Override
            protected Transformer initialValue() {
                try {
                    Transformer domTransformer = XmlUtil.getTransformerFactory().newTransformer();
                    domTransformer.setOutputProperty("omit-xml-declaration", "yes");
                    domTransformer.setOutputProperty("indent", "yes");
                    domTransformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
                    return domTransformer;
                }
                catch (TransformerConfigurationException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        documentBuilder = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                DocumentBuilderFactory myDocumentBuilderFactory = XmlUtil.getDocumentBuilderFactory();
                myDocumentBuilderFactory.setNamespaceAware(true);
                myDocumentBuilderFactory.setExpandEntityReferences(false);
                try {
                    return myDocumentBuilderFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException("Exception while creating document builder " + e.getMessage(), e);
                }
            }
        };
    }

    public static class NamespaceValue {
        private String prefix;
        private String localPart;

        public NamespaceValue(String prefix, String localPart) {
            this.setPrefix(prefix);
            this.setLocalPart(localPart);
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setLocalPart(String localPart) {
            this.localPart = localPart;
        }

        public String getLocalPart() {
            return this.localPart;
        }
    }
}

