/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.foreach;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class CompletionConditionParallelForEachTest
extends BpelTestCase {
    public CompletionConditionParallelForEachTest() {
        super("http://orchestra.ow2.org/parallelForeach", "completionConditionParallelForeach", BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testCompletionConditionParallelForEach() {
        this.deploy();
        this.launch(1, 6, 3);
        this.undeploy();
    }

    public void testCompletionConditionParallelForEachSuccessfulOnly() {
        this.deploy();
        this.launch(1, 6, -3);
        this.undeploy();
    }

    public void testGreaterCompletionConditionParallelForEach() {
        this.deploy();
        BpelFaultException e = this.launchInvalid(1, 6, 8);
        Assert.assertNotNull((String)"InvalidBranchCondition expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidBranchCondition.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public long launch(int start, int stop, int branches) {
        int i;
        int callCount = Math.max(0, stop - start + 1);
        BpelTestCase.CallResult[] callResults = new BpelTestCase.CallResult[callCount];
        QName portTypeQName = new QName(this.getProcessNamespace(), "parallelForeachPT");
        String operationName = "start";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        parts.put("branches", BpelXmlUtil.createElementWithContent((String)Integer.toString(branches)));
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        operationName = "initiate";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(i)));
            parts.put("id", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i)));
            this.call(parts, portTypeQName, operationName);
        }
        operationName = "submit";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i - 1)));
            callResults[i] = this.call(parts, portTypeQName, operationName);
            if ((branches <= 0 || i >= branches) && (branches >= 0 || i >= -branches)) continue;
            callResults[i].getMessageCarrier().getMessage();
        }
        long endTime = System.currentTimeMillis();
        MessageVariable reply = callResult.getMessageCarrier().getMessage();
        String[] counts = reply.getPartValue("count").getTextContent().split(",");
        Assert.assertTrue((boolean)counts[0].equals("s"));
        int expectedSize = branches < 0 ? -branches : branches;
        Assert.assertEquals((String)("invalid counts " + reply.getPartValue("count").getTextContent() + " length"), (int)(++expectedSize), (int)counts.length);
        this.deleteInstance(callResult);
        return endTime;
    }

    public BpelFaultException launchInvalid(int start, int stop, int branches) {
        int i;
        int callCount = Math.max(0, stop - start + 1);
        BpelTestCase.CallResult[] callResults = new BpelTestCase.CallResult[callCount];
        QName portTypeQName = new QName(this.getProcessNamespace(), "parallelForeachPT");
        String operationName = "start";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        parts.put("branches", BpelXmlUtil.createElementWithContent((String)Integer.toString(branches)));
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        operationName = "initiate";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(i)));
            parts.put("id", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i)));
            this.call(parts, portTypeQName, operationName);
        }
        operationName = "submit";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i - 1)));
            callResults[i] = this.call(parts, portTypeQName, operationName);
        }
        BpelFaultException exception = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), BpelFaultException.class);
        this.deleteInstances(1);
        return exception;
    }
}

