/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.perf.flow;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.perf.AbstractPerfTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class FlowTest
extends AbstractPerfTestCase {
    public FlowTest() {
        super("http://example.com/flow", "flow");
    }

    public long launch() {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("in", BpelXmlUtil.createElementWithContent((String)"Dupont"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        long endTime = callResult.getEndTime();
        MessageVariable reply = callResult.getMessageCarrier().getMessage();
        if (reply == null) {
            throw new OrchestraRuntimeException("reply is null");
        }
        Element element = reply.getPartValue("out");
        if (element == null) {
            throw new OrchestraRuntimeException("reply.out is null");
        }
        String result = element.getTextContent();
        if (result == null) {
            throw new OrchestraRuntimeException("reply.out.textContent is null");
        }
        String expected = "flowResultABCDE_AE_BF";
        if (!result.equals("flowResultABCDE_AE_BF")) {
            throw new OrchestraRuntimeException("reply.out.textContent is not flowResultABCDE_AE_BF, it is : " + result);
        }
        this.deleteInstance(callResult);
        return endTime;
    }

    public void testFlow() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void testFlowHibernateCache() {
        this.deploy();
        this.launch();
        this.beginCacheTest();
        this.launch();
        this.endCacheTest();
        this.undeploy();
    }

    public String getAlias() {
        return "class.flow";
    }
}

