/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.management;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.AccessorUtil;
import org.ow2.orchestra.facade.ManagementAPI;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.OrchestraException;
import org.ow2.orchestra.test.remote.RemoteTestCase;

public class GetProcessContractLocationRemoteTest
extends RemoteTestCase {
    private static final String PROCESS_MANAGEMENT_NAME = "managementApiTest";
    private static final String MANAGEMENT_NAME_SPACE = "http://orchestra.ow2.org/tests/management/";
    private static final String PROCESS_HELLO_NAME = "helloworld";
    private static final String HELLO_NAME_SPACE = "http://example.com/helloworld";
    private static final String MANAGEMENT_EXPECTED_URI = "/managementPort?wsdl";
    private static final String MANAGEMENT_CONTINUE_EXPECTED_URI = "/managementContinuePort?wsdl";
    private static final String HELLO_EXPECTED_URI = "/helloworldPort?wsdl";

    public ProcessDefinition deploy() throws IOException, OrchestraException {
        return this.deployBar("managementApiTest.bpel", "managementApiTest.wsdl");
    }

    public void undeploy() {
        this.undeploy(new QName(MANAGEMENT_NAME_SPACE, PROCESS_MANAGEMENT_NAME));
    }

    public void testGetProcessContractLocation() throws Exception {
        ManagementAPI queryDefinitionAPI = AccessorUtil.getManagementAPI((String)this.jmxServiceUrl, (String)this.jmxObjectName);
        ProcessDefinition managementProcessDefinition = this.deploy();
        ProcessDefinition helloProcessDefinition = this.deployBar("helloworld.bpel", "helloworld.wsdl");
        Map contractLocationURIs = queryDefinitionAPI.getWSContractLocation(managementProcessDefinition.getProcessDefinitionUUID());
        GetProcessContractLocationRemoteTest.assertNotNull((Object)contractLocationURIs);
        GetProcessContractLocationRemoteTest.assertEquals((int)2, (int)contractLocationURIs.size());
        GetProcessContractLocationRemoteTest.assertTrue((boolean)contractLocationURIs.containsKey("createBinding"));
        GetProcessContractLocationRemoteTest.assertTrue((boolean)contractLocationURIs.containsKey("continueBinding"));
        GetProcessContractLocationRemoteTest.assertTrue((boolean)contractLocationURIs.containsValue(MANAGEMENT_EXPECTED_URI));
        GetProcessContractLocationRemoteTest.assertTrue((boolean)contractLocationURIs.containsValue(MANAGEMENT_CONTINUE_EXPECTED_URI));
        contractLocationURIs = queryDefinitionAPI.getWSContractLocation(helloProcessDefinition.getProcessDefinitionUUID());
        GetProcessContractLocationRemoteTest.assertNotNull((Object)contractLocationURIs);
        GetProcessContractLocationRemoteTest.assertEquals((int)1, (int)contractLocationURIs.size());
        GetProcessContractLocationRemoteTest.assertTrue((boolean)contractLocationURIs.containsKey("helloworldPTSOAPBinding"));
        GetProcessContractLocationRemoteTest.assertTrue((boolean)contractLocationURIs.containsValue(HELLO_EXPECTED_URI));
        this.undeploy(managementProcessDefinition.getProcessDefinitionUUID());
        this.undeploy(helloProcessDefinition.getProcessDefinitionUUID());
    }
}

