/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util.wsdl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.util.wsdl.WSDLLocatorImpl;
import org.ow2.orchestra.util.wsdl.WsdlException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlUtil {
    private WsdlUtil() {
    }

    public static Definition readWsdl(WSDLLocator locator) {
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            return wsdlReader.readWSDL(locator);
        }
        catch (WsdlException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WsdlException("Problem while reading wsdl file at URL : " + locator.getBaseURI(), e);
        }
    }

    public static Definition readWsdl(URL wsdlURL) {
        return WsdlUtil.readWsdl(new WSDLLocatorImpl(wsdlURL));
    }

    public static Definition readWsdl(Element wsdlDefinitionElt) {
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            return wsdlReader.readWSDL((String)null, wsdlDefinitionElt);
        }
        catch (Exception e) {
            throw new WsdlException("Problem while reading wsdl from element : " + XmlUtil.toString(wsdlDefinitionElt), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeWsdl(Definition wsdlDefinition) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            WsdlUtil.writeWsdl(wsdlDefinition, baos);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return baos.toString();
    }

    public static void writeWsdl(Definition wsdlDefinition, OutputStream sink) {
        try {
            WSDLWriter wsdlReader = WSDLFactory.newInstance().newWSDLWriter();
            wsdlReader.writeWSDL(wsdlDefinition, sink);
        }
        catch (Exception e) {
            throw new WsdlException("Problem while writing wsdl:", e);
        }
    }

    public static List<Service> getServicesOfPortType(QName portTypeQName, Set<Definition> wsdlDefinitions) {
        ArrayList<Service> matchinServices = new ArrayList<Service>();
        for (Definition wsdlDefinition : wsdlDefinitions) {
            for (Service service : wsdlDefinition.getServices().values()) {
                for (Port port : service.getPorts().values()) {
                    if (!port.getBinding().getPortType().getQName().equals(portTypeQName)) continue;
                    matchinServices.add(service);
                }
            }
        }
        return matchinServices;
    }
}

