/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.runtime;

import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.activities.receive.ReceiveTest;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class TestInstanceActionsOnTerminated
extends BpelTestCase {
    public TestInstanceActionsOnTerminated() {
        super("http://example.com/receive", "receive");
    }

    public void testResume() {
        this.deploy(ReceiveTest.class.getResource(this.getProcessName() + ".bpel"));
        this.launch(0);
        this.undeploy();
    }

    public void testSuspend() {
        this.deploy(ReceiveTest.class.getResource(this.getProcessName() + ".bpel"));
        this.launch(1);
        this.undeploy();
    }

    private void suspendInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                callResult.getInstance().suspendInstance();
                return null;
            }
        });
    }

    private void resumeInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                callResult.getInstance().resumeInstance();
                return null;
            }
        });
    }

    public void launch(int test) {
        URL bigProduct = ReceiveTest.class.getResource("bigProduct.xml");
        this.assertExists(bigProduct);
        URL stElement = ReceiveTest.class.getResource("stElement.xml");
        this.assertExists(stElement);
        URL intElement = ReceiveTest.class.getResource("intElement.xml");
        this.assertExists(intElement);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("product", XmlUtil.getDocumentFromURL((URL)bigProduct).getDocumentElement());
        parts.put("stElement", XmlUtil.getDocumentFromURL((URL)stElement).getDocumentElement());
        parts.put("stType", BpelXmlUtil.createElementWithContent((String)"Dupont"));
        parts.put("intElement", XmlUtil.getDocumentFromURL((URL)intElement).getDocumentElement());
        parts.put("intType", BpelXmlUtil.createElementWithContent((String)"5"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult result = this.call(parts, portTypeQName, "submit");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        ProcessInstanceUUID piuuid = (ProcessInstanceUUID)commandService.execute((Command)new Command<ProcessInstanceUUID>(){

            public ProcessInstanceUUID execute(Environment environment) {
                return result.getProcessInstanceUUID();
            }
        });
        this.waitForInstanceEnd(piuuid);
        if (test == 0) {
            this.resumeInstanceMethod(result);
            commandService.execute((Command)new Command<Object>(){

                public Object execute(Environment environment) {
                    Querier querier = EnvTool.getQuerier();
                    Set set = querier.findProcessInstances(ActivityState.RUNNING);
                    Assert.assertEquals((boolean)true, (boolean)set.isEmpty());
                    return null;
                }
            });
        } else if (test == 1) {
            this.suspendInstanceMethod(result);
            commandService.execute((Command)new Command<Object>(){

                public Object execute(Environment environment) {
                    Querier querier = EnvTool.getQuerier();
                    Set set = querier.findProcessInstances(ActivityState.SUSPENDED);
                    Assert.assertEquals((boolean)true, (boolean)set.isEmpty());
                    return null;
                }
            });
        }
        this.waitForInstanceEnd(piuuid);
        this.deleteInstance(result);
    }
}

