/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util.wsdl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.util.wsdl.WSDLLocatorImpl;
import org.ow2.orchestra.util.wsdl.WsdlException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsdlUtil {
    private WsdlUtil() {
    }

    public static Definition readWsdl(WSDLLocator locator) {
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            return wsdlReader.readWSDL(locator);
        }
        catch (WsdlException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WsdlException("Problem while reading wsdl file at URL : " + locator.getBaseURI(), e);
        }
    }

    public static Definition readWsdl(URL wsdlURL) {
        return WsdlUtil.readWsdl(new WSDLLocatorImpl(wsdlURL));
    }

    public static Definition readWsdl(Element wsdlDefinitionElt) {
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            return wsdlReader.readWSDL((String)null, wsdlDefinitionElt);
        }
        catch (Exception e) {
            throw new WsdlException("Problem while reading wsdl from element : " + XmlUtil.toString(wsdlDefinitionElt), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeWsdl(Definition wsdlDefinition) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            WsdlUtil.writeWsdl(wsdlDefinition, baos);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return baos.toString();
    }

    public static void writeWsdl(Definition wsdlDefinition, OutputStream sink) {
        try {
            WSDLWriter wsdlReader = WSDLFactory.newInstance().newWSDLWriter();
            wsdlReader.writeWSDL(wsdlDefinition, sink);
        }
        catch (Exception e) {
            throw new WsdlException("Problem while writing wsdl:", e);
        }
    }

    public static List<Service> getServicesOfPortType(QName portTypeQName, Set<Definition> wsdlDefinitions) {
        ArrayList<Service> matchinServices = new ArrayList<Service>();
        for (Definition wsdlDefinition : wsdlDefinitions) {
            for (Service service : wsdlDefinition.getServices().values()) {
                for (Port port : service.getPorts().values()) {
                    if (!port.getBinding().getPortType().getQName().equals(portTypeQName)) continue;
                    matchinServices.add(service);
                }
            }
        }
        return matchinServices;
    }

    public static <T extends ExtensibilityElement> T getExtensibilityElement(List<? extends ExtensibilityElement> list, Class<T> clazz) {
        List<T> elements = WsdlUtil.getExtensibilityElements(list, clazz);
        return (T)(elements.isEmpty() ? null : (ExtensibilityElement)elements.get(0));
    }

    public static <T extends ExtensibilityElement> List<T> getExtensibilityElements(List<? extends ExtensibilityElement> list, Class<T> clazz) {
        ArrayList<ExtensibilityElement> result = new ArrayList<ExtensibilityElement>();
        for (ExtensibilityElement extensibilityElement : list) {
            if (!clazz.isAssignableFrom(extensibilityElement.getClass())) continue;
            result.add(extensibilityElement);
        }
        return result;
    }

    public static String getSoapAction(BindingOperation bindingOperation) {
        List list = bindingOperation.getExtensibilityElements();
        SOAPOperation soapOperation = WsdlUtil.getExtensibilityElement(list, SOAPOperation.class);
        if (soapOperation != null) {
            return soapOperation.getSoapActionURI();
        }
        return null;
    }

    public static Binding getBindingForOperation(Definition definition, BindingOperation bindingOperation) {
        Map services = definition.getAllServices();
        for (Service service : services.values()) {
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                Binding binding = port.getBinding();
                List bindingOperations = binding.getBindingOperations();
                for (BindingOperation op : bindingOperations) {
                    if (!op.getName().equals(bindingOperation.getName())) continue;
                    return binding;
                }
            }
        }
        Map bindings = definition.getAllBindings();
        for (QName qName : bindings.keySet()) {
            Binding binding = definition.getBinding(qName);
            List bindingOperations = binding.getBindingOperations();
            for (BindingOperation op : bindingOperations) {
                if (!op.getName().equals(bindingOperation.getName())) continue;
                return binding;
            }
        }
        return null;
    }

    public static BindingOperation getBindingOperation(Definition definition, String operationName) {
        Map services = definition.getAllServices();
        for (QName qName : services.keySet()) {
            Service service = definition.getService(qName);
            Map ports = service.getPorts();
            for (String key : ports.keySet()) {
                Port port = service.getPort(key);
                BindingOperation bindingOperation = port.getBinding().getBindingOperation(operationName, null, null);
                if (bindingOperation == null) continue;
                return bindingOperation;
            }
        }
        Map bindings = definition.getAllBindings();
        for (QName key : bindings.keySet()) {
            Binding binding = (Binding)bindings.get(key);
            BindingOperation bindingOperation = binding.getBindingOperation(operationName, null, null);
            if (bindingOperation == null) continue;
            return bindingOperation;
        }
        return null;
    }

    public static boolean isRpc(Definition definition, BindingOperation bindingOperation) {
        SOAPOperation soapOperation = WsdlUtil.getExtensibilityElement(bindingOperation.getExtensibilityElements(), SOAPOperation.class);
        if ("rpc".equalsIgnoreCase(soapOperation.getStyle())) {
            return true;
        }
        Binding binding = WsdlUtil.getBindingForOperation(definition, bindingOperation);
        SOAPBinding soapBinding = WsdlUtil.getExtensibilityElement(binding.getExtensibilityElements(), SOAPBinding.class);
        return "rpc".equalsIgnoreCase(soapBinding.getStyle());
    }
}

