/**
 * Copyright (C) 2009  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.cxf;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

import org.ow2.orchestra.env.BpelEnvironmentParser;
import org.ow2.orchestra.jmx.JMXAgent;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.util.Misc;

public class OrchestraCxfServlet extends OrchestraBaseCxfServlet {

  private static final long serialVersionUID = 2528286722832028480L;

  private final JMXAgent jmxAgent = new JMXAgent();

  // Default environment for deployed services
  private static final String DEFAULT_ENV_CONFIG_FILE = "conf/environment.xml";
  private static final String DEFAULT_ENV_CONFIG_RESOURCE = "environment.xml";

  @Override
  public void init(final ServletConfig servletConfig) throws ServletException {
    super.init(servletConfig);

    URL envUrl = null;
    final File envFile = new File(OrchestraCxfServlet.DEFAULT_ENV_CONFIG_FILE);
    if (envFile.exists()) {
      try {
        envUrl = envFile.toURL();
      } catch (final MalformedURLException e) {
        Misc.unreachableStatement();
      }
    }
    if (envUrl == null) {
      envUrl = ReflectUtil.getResource(null, OrchestraCxfServlet.DEFAULT_ENV_CONFIG_RESOURCE);
    }
    Misc.log(Level.INFO, "Environment will be taken from: %s", envUrl);

    final EnvironmentFactory envFactory = BpelEnvironmentParser.parseEnvironmentFactoryFromURL(envUrl);

    this.jmxAgent.startOrchestra(envFactory);
  }

  @Override
  public void destroy() {
    super.destroy();

    this.jmxAgent.stopOrchestra();
  }
}
